/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.steering;

import cz.cuni.amis.pogamut.base.agent.navigation.PathEventType;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorListener;
import cz.cuni.amis.pogamut.base.agent.navigation.steering.SteeringEventListener;
import cz.cuni.amis.pogamut.base.agent.navigation.steering.SteeringEventType;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UTPathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.steering.AbstractUT2004SteeringExecutor;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;

public class TeleporterSteeringExecutor
extends AbstractUT2004SteeringExecutor
implements SteeringEventListener {
    private NavPoint secondTeleporter;
    private Location forwardLocation;

    public TeleporterSteeringExecutor(IWorldView worldView, UTPathExecutor executor) {
        super(worldView, executor);
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        ((UTPathExecutor)this.executor).addPathListener(new PathExecutorListener(){

            @Override
            public void onEvent(PathEventType type) {
                if (type.equals((Object)PathEventType.PATH_ELEMENT_REACHED)) {
                    TeleporterSteeringExecutor.this.checkEnteringTeleporter();
                }
            }
        });
    }

    private void checkEnteringTeleporter() {
        if (((UTPathExecutor)this.executor).getNextPathElement() instanceof NavPoint && ((UTPathExecutor)this.executor).getLastReachedPathElement() instanceof NavPoint) {
            NavPoint nextNav = (NavPoint)((UTPathExecutor)this.executor).getNextPathElement();
            NavPoint currentNav = (NavPoint)((UTPathExecutor)this.executor).getLastReachedPathElement();
            if (nextNav.isTeleporter() && currentNav.isTeleporter()) {
                if ((Integer)this.flag.getFlag() == 0) {
                    this.secondTeleporter = nextNav;
                    if (this.getPreviousNavPointLocation() != null) {
                        this.forwardLocation = this.getAgentLocation().add(this.getAgentVelocity());
                    }
                    ((UTPathExecutor)this.executor).logInfo("TELEPORTER STEERING ---- flag to: 36\n" + this.getAgentLocation() + "\n" + this.forwardLocation + "\n" + nextNav.getLocation());
                    this.flag.setFlag(36);
                }
            } else if ((Integer)this.flag.getFlag() > 0 && this.secondTeleporter.getLocation().getDistance(this.getAgentLocation()) < 300.0) {
                ((UTPathExecutor)this.executor).logInfo("TELEPORTER STEERING ---- flag to: 0");
                this.flag.setFlag(0);
            }
        }
    }

    private Velocity getAgentVelocity() {
        return this.worldView.getSingle(Self.class).getVelocity();
    }

    private Location getPreviousNavPointLocation() {
        if (((UTPathExecutor)this.executor).getNextPathElement(-1) != null) {
            return ((ILocated)((UTPathExecutor)this.executor).getNextPathElement(-1)).getLocation();
        }
        return null;
    }

    @Override
    public boolean execute() {
        if (((UTPathExecutor)this.executor).getNextPathElement() != null) {
            ((UTPathExecutor)this.executor).logInfo("TELEPORTER STEERING ---- Moving to: " + this.forwardLocation);
            ((UTPathExecutor)this.executor).moveTo(this.forwardLocation);
        }
        ((UTPathExecutor)this.executor).moveToNext();
        ((UTPathExecutor)this.executor).logInfo("NextNav: " + this.getNextNavId());
        return true;
    }

    private String getNextNavId() {
        if (((UTPathExecutor)this.executor).getNextPathElement() instanceof NavPoint) {
            return ((NavPoint)((UTPathExecutor)this.executor).getNextPathElement()).getId().getStringId();
        }
        return null;
    }

    @Override
    protected void terminate() {
        super.terminate();
    }

    @Override
    public void steeringEventOccured(SteeringEventType steeringEvent) {
    }
}

