/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.steering;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UTPathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.steering.AbstractUT2004SteeringExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.steering.AgentSteeringUtils;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.IncomingProjectile;

public class ProjectileSteeringExecutor
extends AbstractUT2004SteeringExecutor {
    protected IncomingProjectile incomingPrj;
    private AgentSteeringUtils agentSteeringUtils;
    protected boolean executing = false;
    protected IWorldObjectEventListener<IncomingProjectile, WorldObjectUpdatedEvent<IncomingProjectile>> projectileListener;

    public ProjectileSteeringExecutor(IWorldView worldView, UTPathExecutor executor) {
        super(worldView, executor);
        this.agentSteeringUtils = new AgentSteeringUtils(worldView);
        this.agentSteeringUtils.AVOID_OBSTACLE_FUNCTION_MULTI = 1.5;
        this.agentSteeringUtils.AVOID_OBSTACLE_RUN_VECTOR_LENGTH = 750.0;
    }

    @Override
    public void initialize() {
        super.initialize();
        this.executing = false;
    }

    @Override
    protected void registerListeners() {
        this.projectileListener = new IWorldObjectEventListener<IncomingProjectile, WorldObjectUpdatedEvent<IncomingProjectile>>(){

            @Override
            public void notify(WorldObjectUpdatedEvent<IncomingProjectile> event) {
                if (ProjectileSteeringExecutor.this.getNearestProjectileDistance() < 2000.0) {
                    ProjectileSteeringExecutor.this.flag.setFlag(50);
                } else {
                    ProjectileSteeringExecutor.this.flag.setFlag(0);
                }
            }
        };
        this.worldView.addObjectListener(IncomingProjectile.class, WorldObjectUpdatedEvent.class, this.projectileListener);
    }

    public Double getNearestProjectileDistance() {
        if (this.getNearestProjectile() != null) {
            return this.getAgentLocation().getDistance(this.getNearestProjectile().getLocation());
        }
        return Double.MAX_VALUE;
    }

    protected IncomingProjectile getNearestProjectile() {
        double dist = Double.MAX_VALUE;
        IncomingProjectile result = null;
        for (IncomingProjectile prj : this.worldView.getAll(IncomingProjectile.class).values()) {
            double distTmp = prj.getLocation().getDistance(this.getAgentLocation());
            if (!(distTmp < dist)) continue;
            dist = distTmp;
            result = prj;
        }
        return result;
    }

    @Override
    public boolean execute() {
        Location[] newLocations;
        ((UTPathExecutor)this.executor).logInfo("---- PROJECTILE STEERING ---- EXECUTE");
        Location[] locations = new Location[2];
        Location location = locations[0] = ((UTPathExecutor)this.executor).getNextPathElement() == null ? null : ((ILocated)((UTPathExecutor)this.executor).getNextPathElement()).getLocation();
        if (((UTPathExecutor)this.executor).getNextPathElement(1) != null) {
            locations[1] = ((ILocated)((UTPathExecutor)this.executor).getNextPathElement(1)).getLocation();
        }
        if ((newLocations = this.agentSteeringUtils.adjustLocations(locations)).length > 1) {
            ((UTPathExecutor)this.executor).moveTo(newLocations[0], newLocations[1]);
        } else {
            ((UTPathExecutor)this.executor).moveTo(newLocations[0]);
        }
        return true;
    }
}

