/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.steering;

import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UTPathExecutor;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.TurnTo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Mover;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.util.Map;

public enum LiftSteeringState {
    ENTERING_LIFT{

        @Override
        public boolean isInState(IWorldView view, UTPathExecutor executor) {
            return this.getNavpointLiftType(this.getLastNavPoint(executor)).equals((Object)Lift.LIFT_EXIT) && this.getNavpointLiftType(this.getNextNavPoint(executor)).equals((Object)Lift.LIFT_CENTER);
        }

        @Override
        public LiftSteeringState switchToNextState(IWorldView view, UTPathExecutor executor) {
            if (this.isCloseMoverDown(view, this.getAgentLocation(view))) {
                return RIDING_LIFT;
            }
            executor.log("---- REGRESING FROM THE LIFT ---- ");
            executor.goStepsBack(2);
            return null;
        }

        @Override
        public boolean shouldSwitchToNext(IWorldView view, UTPathExecutor executor) {
            return this.getNavpointLiftType(this.getLastNavPoint(executor)).equals((Object)Lift.LIFT_CENTER) && this.getNavpointLiftType(this.getNextNavPoint(executor)).equals((Object)Lift.LIFT_EXIT);
        }

        @Override
        public void execute(IWorldView view, IAct act, UTPathExecutor executor) {
            if (this.isCloseMoverDown(view, this.getNextNavPoint(executor).getLocation())) {
                this.log(executor, " running to navpoint: " + this.getNextNavPoint(executor).getId().getStringId());
                executor.moveTo(this.getNextNavPoint(executor).getLocation());
            }
        }
    }
    ,
    RIDING_LIFT{

        @Override
        public boolean isInState(IWorldView view, UTPathExecutor executor) {
            return this.getNavpointLiftType(this.getLastNavPoint(executor)).equals((Object)Lift.LIFT_CENTER) && this.getNavpointLiftType(this.getNextNavPoint(executor)).equals((Object)Lift.LIFT_EXIT);
        }

        @Override
        public LiftSteeringState switchToNextState(IWorldView view, UTPathExecutor executor) {
            return EXITING_LIFT;
        }

        @Override
        public void execute(IWorldView view, IAct act, UTPathExecutor executor) {
            this.log(executor, "Turning to the exit");
            act.act(new TurnTo().setTarget(this.getNextNavPoint(executor).getId()));
        }

        @Override
        public boolean shouldSwitchToNext(IWorldView view, UTPathExecutor executor) {
            if (this.getNextNavPoint(executor) == null) {
                return true;
            }
            if (this.getAgentLocation((IWorldView)view).z + 150.0 > this.getNextNavPoint((UTPathExecutor)executor).getLocation().z) {
                return true;
            }
            this.log(executor, String.valueOf(this.getAgentLocation((IWorldView)view).z) + " " + this.getNextNavPoint((UTPathExecutor)executor).getLocation().z);
            return false;
        }
    }
    ,
    EXITING_LIFT{

        @Override
        public boolean isInState(IWorldView view, UTPathExecutor executor) {
            return this.getNavpointLiftType(this.getNextNavPoint(executor)).equals((Object)Lift.LIFT_EXIT);
        }

        @Override
        public LiftSteeringState switchToNextState(IWorldView view, UTPathExecutor executor) {
            return null;
        }

        @Override
        public boolean shouldSwitchToNext(IWorldView view, UTPathExecutor executor) {
            return !this.isInState(view, executor);
        }

        @Override
        public void execute(IWorldView view, IAct act, UTPathExecutor executor) {
            this.log(executor, " running to navpoint: " + this.getNextNavPoint(executor).getId().getStringId());
            executor.moveTo(this.getNextNavPoint(executor).getLocation());
        }
    };

    private static final String LIFT_EXIT = "LiftExit";
    private static final String LIFT_CENTER = "LiftCenter";

    private LiftSteeringState() {
    }

    public boolean isInState(IWorldView view, UTPathExecutor executor) {
        return false;
    }

    protected Location getAgentLocation(IWorldView view) {
        return new Location(view.getSingle(Self.class).getLocation());
    }

    public void execute(IWorldView view, IAct act, UTPathExecutor executor) {
    }

    public LiftSteeringState switchToNextState(IWorldView view, UTPathExecutor executor) {
        return null;
    }

    public boolean shouldSwitchToNext(IWorldView view, UTPathExecutor executor) {
        return false;
    }

    protected Lift getNavpointLiftType(NavPoint np) {
        if (np == null) {
            return Lift.NO_LIFT;
        }
        if (np.getId().getStringId().contains(LIFT_EXIT)) {
            return Lift.LIFT_EXIT;
        }
        if (np.getId().getStringId().contains(LIFT_CENTER)) {
            return Lift.LIFT_CENTER;
        }
        return Lift.NO_LIFT;
    }

    protected NavPoint getLastNavPoint(UTPathExecutor executor) {
        if (executor.getLastReachedPathElement() instanceof NavPoint) {
            return (NavPoint)executor.getLastReachedPathElement();
        }
        return null;
    }

    protected NavPoint getNextNavPoint(UTPathExecutor executor) {
        if (executor.getNextPathElement() != null && executor.getNextPathElement() instanceof NavPoint) {
            return (NavPoint)executor.getNextPathElement();
        }
        return null;
    }

    protected Location getAgentFloorLocation(IWorldView view) {
        return view.getSingle(Self.class).getFloorLocation();
    }

    protected void log(UTPathExecutor executor, String string) {
        executor.log(String.valueOf(this.name()) + " ---- " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isCloseMoverDown(IWorldView view, Location location) {
        Map<WorldObjectId, Mover> movers = view.getAll(Mover.class);
        Mover mover = null;
        Map<WorldObjectId, Mover> map = movers;
        synchronized (map) {
            double distance = Double.MAX_VALUE;
            for (Mover currentMover : movers.values()) {
                if (!(currentMover.getLocation().getDistance(location) < distance)) continue;
                mover = currentMover;
                distance = mover.getLocation().getDistance(location);
            }
        }
        return mover != null && mover.getLocation().getZ() < location.getZ();
    }

    /* synthetic */ LiftSteeringState(String string, int n, LiftSteeringState liftSteeringState) {
        this();
    }

    protected static enum Lift {
        LIFT_EXIT,
        LIFT_CENTER,
        NO_LIFT;

    }
}

