/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.steering;

import cz.cuni.amis.pogamut.base.agent.navigation.PathEventType;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorListener;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UTPathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.steering.AbstractUT2004SteeringExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.steering.LiftSteeringState;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;

public class LiftSteeringExecutor
extends AbstractUT2004SteeringExecutor {
    private LiftSteeringState currentState = null;
    private IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>> selfListener;
    private Double lastLocationZ = null;

    @Override
    public void initialize() {
        super.initialize();
        this.MAX_BEGIN_COUNT_FOR_ERROR = 10;
    }

    public LiftSteeringExecutor(IWorldView worldView, UTPathExecutor executor) {
        super(worldView, executor);
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        ((UTPathExecutor)this.executor).addPathListener(new PathExecutorListener(){

            @Override
            public void onEvent(PathEventType type) {
                if (type.equals((Object)PathEventType.PATH_ELEMENT_REACHED)) {
                    LiftSteeringExecutor.this.checkEnteringLift();
                }
            }
        });
        this.selfListener = new IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>>(){

            @Override
            public void notify(WorldObjectUpdatedEvent<Self> event) {
                Self self = (Self)event.getObject();
                if (LiftSteeringExecutor.this.currentState != null && LiftSteeringExecutor.this.currentState.equals((Object)LiftSteeringState.RIDING_LIFT) && LiftSteeringExecutor.this.lastLocationZ != null && !LiftSteeringExecutor.this.lastLocationZ.equals(self.getLocation().getZ())) {
                    LiftSteeringExecutor.this.execute();
                }
                LiftSteeringExecutor.this.lastLocationZ = self.getLocation().getZ();
            }
        };
        this.worldView.addObjectListener(Self.class, WorldObjectUpdatedEvent.class, this.selfListener);
    }

    @Override
    public boolean execute() {
        super.execute();
        if (this.currentState == null) {
            ((UTPathExecutor)this.executor).logInfo("LIFT STEERING ---- end of execution.");
            this.terminate();
        }
        if (this.currentState != null && this.currentState.shouldSwitchToNext(this.worldView, (UTPathExecutor)this.executor)) {
            this.currentState = this.currentState.switchToNextState(this.worldView, (UTPathExecutor)this.executor);
            ((UTPathExecutor)this.executor).logInfo("LIFT STEERING ---- switching to state: " + (this.currentState == null ? "null" : this.currentState.name()));
        }
        if (this.currentState != null && this.currentState.isInState(this.worldView, (UTPathExecutor)this.executor)) {
            ((UTPathExecutor)this.executor).logInfo("LIFT STEERING ---- execution of state: " + (Object)((Object)this.currentState));
            this.currentState.execute(this.worldView, this.getCommandSerializer(), (UTPathExecutor)this.executor);
        } else {
            ((UTPathExecutor)this.executor).logInfo("LIFT STEERING ---- not in state: " + (Object)((Object)this.currentState));
            this.currentState = null;
            this.terminate();
        }
        return true;
    }

    private void checkEnteringLift() {
        if (LiftSteeringState.ENTERING_LIFT.isInState(this.worldView, (UTPathExecutor)this.executor)) {
            this.currentState = LiftSteeringState.ENTERING_LIFT;
            ((UTPathExecutor)this.executor).logInfo("LIFT STEERING ---- flag to: 25");
            this.flag.setFlag(25);
        }
    }
}

