/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.steering;

import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UTPathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.steering.AbstractUT2004SteeringExecutor;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.AddRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Configuration;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Jump;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.WallCollision;
import javax.vecmath.Vector3d;

public class HitSomethingSteeringExecutor
extends AbstractUT2004SteeringExecutor {
    protected static final String FRONT_MIDDLE = "FRONT_MIDDLE";
    protected static final String FRONT_UPPER = "FRONT_UPPER";
    private IWorldEventListener<WallCollision> wallListener;
    private boolean initialized = false;
    private Location lastJumpLocation;

    public HitSomethingSteeringExecutor(IWorldView worldView, UTPathExecutor executor) {
        super(worldView, executor);
    }

    @Override
    protected void beginMessageEvent() {
        super.beginMessageEvent();
        if (this.executing && this.lastJumpLocation != null && this.getAgentLocation() != null && this.lastJumpLocation.getDistance(this.getAgentLocation()) > 70.0) {
            this.log("HIT SOMETHING ---- terminate");
            this.terminate();
        } else if (this.executing && this.beginCount % 4 == 0) {
            this.flag.setFlag(19);
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.initialized) {
            this.getAct().act(new Configuration().setDrawTraceLines(true).setAutoTrace(true));
            this.getAct().act(new AddRay(FRONT_MIDDLE, new Vector3d(1.0, 0.0, 0.0), 150, true, true, true));
            this.getAct().act(new AddRay(FRONT_UPPER, new Vector3d(1.0, 0.0, 1.0), 200, true, true, true));
            this.initialized = true;
        }
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.wallListener = new IWorldEventListener<WallCollision>(){

            @Override
            public void notify(WallCollision event) {
                HitSomethingSteeringExecutor.this.wallEvent();
            }
        };
        this.worldView.addEventListener(WallCollision.class, this.wallListener);
    }

    protected void wallEvent() {
        if (!this.executing) {
            this.lastJumpLocation = this.getAgentLocation();
            this.log("HIT SOMETHING ---- Starting up");
            this.flag.setFlag(20);
        }
    }

    @Override
    public boolean execute() {
        super.execute();
        if (this.isObstacleJumpeable()) {
            ((UTPathExecutor)this.executor).logInfo("HIT SOMETHING ---- EXECUTING JUMP");
            this.executeJump();
        } else if (this.isObstacleDoubleJumpeable()) {
            ((UTPathExecutor)this.executor).logInfo("HIT SOMETHING ---- EXECUTING DOUBLE JUMP");
            this.executeDoubleJump();
        } else {
            if (this.beginCount % 3 == 0) {
                this.executeDoubleJump();
                return false;
            }
            ((UTPathExecutor)this.executor).logInfo("HIT SOMETHING ---- UNABLE TO JUMP");
        }
        return true;
    }

    protected IAct getAct() {
        return ((UTPathExecutor)this.executor).getCommandSerializer();
    }

    protected void executeJump() {
        this.getCommandSerializer().act(new Jump());
    }

    protected void executeDoubleJump() {
        this.getCommandSerializer().act(new Jump(true));
    }

    protected boolean isObstacleDoubleJumpeable() {
        if (this.getUpperTrace() == null) {
            return true;
        }
        return !this.getUpperTrace().isResult();
    }

    protected boolean isObstacleJumpeable() {
        if (this.getMiddleTrace() == null) {
            return true;
        }
        return !this.getMiddleTrace().isResult();
    }

    protected AutoTraceRay getUpperTrace() {
        return this.getAutoTrace(FRONT_UPPER);
    }

    protected AutoTraceRay getMiddleTrace() {
        return this.getAutoTrace(FRONT_MIDDLE);
    }

    protected AutoTraceRay getAutoTrace(String id) {
        return this.worldView.getAll(AutoTraceRay.class).get(UnrealId.get(id));
    }
}

