/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.steering;

import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UTPathExecutor;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.WallCollision;

public enum DoorSteeringState {
    ENTERING_DOORS{
        private IWorldEventListener<WallCollision> wallListener;
        private boolean hitSomething = false;

        @Override
        public void execute(IWorldView worldView, IAct commandSerializer, UTPathExecutor executor) {
            this.prepareNavigationPoints(executor);
            executor.moveTo(door.getLocation());
            this.hitSomething = false;
            this.wallListener = new IWorldEventListener<WallCollision>(){

                @Override
                public void notify(WallCollision event) {
                    hitSomething = true;
                }
            };
            worldView.addEventListener(WallCollision.class, this.wallListener);
        }

        private void prepareNavigationPoints(UTPathExecutor executor) {
            int i = -2;
            while (i < 0) {
                if (executor.getPathElement(i) != null && executor.getPathElement(i) instanceof NavPoint) {
                    previous = (NavPoint)executor.getPathElement(i);
                }
                ++i;
            }
            if (executor.getNextPathElement() instanceof NavPoint) {
                door = (NavPoint)executor.getNextPathElement();
            }
            if (executor.getPathElement(1) != null && executor.getPathElement(1) instanceof NavPoint) {
                next = (NavPoint)executor.getNextPathElement(1);
            }
            this.log(executor, "prev:" + previous + "\ndoor: " + door + "\nnext:" + next);
        }

        @Override
        public boolean isInState(IWorldView worldView, UTPathExecutor executor) {
            return door != null || this.getNextNavPoint(executor).isDoor();
        }

        @Override
        public boolean shouldSwitchToNext(IWorldView worldView, UTPathExecutor executor) {
            if (door == null) {
                return false;
            }
            if (this.hitSomething && this.getAgentFloorLocation(worldView).getDistance(door.getLocation()) < 150.0) {
                return true;
            }
            return door.isDoorOpened() && this.getAgentFloorLocation(worldView).getDistance(door.getLocation()) < 300.0;
        }

        @Override
        public DoorSteeringState switchToNextState(IWorldView worldView, UTPathExecutor executor) {
            this.log(executor, "DOOR - ENTERING - SWITCH TO NEXT");
            worldView.removeEventListener(WallCollision.class, this.wallListener);
            if (door != null && door.isDoorOpened()) {
                return RUNNING_THROUGH;
            }
            return STEPPING_BACK;
        }
    }
    ,
    STEPPING_BACK{

        @Override
        public void execute(IWorldView worldView, IAct commandSerializer, UTPathExecutor executor) {
            executor.moveTo(previous.getLocation());
        }

        @Override
        public boolean isInState(IWorldView worldView, UTPathExecutor executor) {
            return true;
        }

        @Override
        public boolean shouldSwitchToNext(IWorldView worldView, UTPathExecutor executor) {
            return previous != null && this.getAgentFloorLocation(worldView).getDistance(previous.getLocation()) < 100.0;
        }

        @Override
        public DoorSteeringState switchToNextState(IWorldView worldView, UTPathExecutor executor) {
            this.log(executor, "DOOR - STEP BACK - SWITCHING TO NEXT - ");
            return RUNNING_THROUGH;
        }
    }
    ,
    RUNNING_THROUGH{

        @Override
        public void execute(IWorldView worldView, IAct commandSerializer, UTPathExecutor executor) {
            this.log(executor, "DOOR - RUN THROUGH - EXECUTE - RUNTO - " + next.getId().getStringId());
            executor.moveTo(door.getLocation(), next.getLocation());
        }

        @Override
        public boolean isInState(IWorldView worldView, UTPathExecutor executor) {
            return true;
        }

        @Override
        public boolean shouldSwitchToNext(IWorldView worldView, UTPathExecutor executor) {
            return this.getAgentFloorLocation(worldView).getDistance(next.getLocation()) < 100.0;
        }

        @Override
        public DoorSteeringState switchToNextState(IWorldView worldView, UTPathExecutor executor) {
            return null;
        }
    };

    protected static NavPoint previous;
    protected static NavPoint door;
    protected static NavPoint next;
    protected Location lastTarget;

    private DoorSteeringState() {
    }

    public abstract boolean shouldSwitchToNext(IWorldView var1, UTPathExecutor var2);

    public abstract DoorSteeringState switchToNextState(IWorldView var1, UTPathExecutor var2);

    public abstract boolean isInState(IWorldView var1, UTPathExecutor var2);

    public abstract void execute(IWorldView var1, IAct var2, UTPathExecutor var3);

    protected NavPoint getLastNavPoint(UTPathExecutor executor) {
        if (executor.getLastReachedPathElement() instanceof NavPoint) {
            return (NavPoint)executor.getLastReachedPathElement();
        }
        return null;
    }

    protected NavPoint getNextNavPoint(UTPathExecutor executor) {
        if (executor.getNextPathElement() != null && executor.getNextPathElement() instanceof NavPoint) {
            return (NavPoint)executor.getNextPathElement();
        }
        return null;
    }

    protected Location getAgentFloorLocation(IWorldView view) {
        return view.getSingle(Self.class).getFloorLocation();
    }

    protected void log(UTPathExecutor executor, String string) {
        executor.log(String.valueOf(this.name()) + " ---- " + string);
    }

    public static void restart() {
        previous = null;
        next = null;
        door = null;
    }

    /* synthetic */ DoorSteeringState(String string, int n, DoorSteeringState doorSteeringState) {
        this();
    }
}

