/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.steering;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.impl.AbstractWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.steering.Algeb;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import java.awt.geom.Point2D;
import java.util.Collection;
import javax.vecmath.Vector3d;

public class AgentSteeringUtils {
    private IWorldView worldView;
    public boolean bAvoidPlayers = true;
    public NavPoint nearestNavLocation;
    public Location lastFollowPathLocation;
    public double AVOID_OBSTACLE_FUNCTION = 250.0;
    public double AVOID_OBSTACLE_FUNCTION_MULTI = 0.5;
    public double AVOID_OBSTACLE_MIN_DISTANCE = 500.0;
    public double AVOID_OBSTACLE_RUN_VECTOR_LENGTH = 300.0;

    AgentSteeringUtils(IWorldView view) {
        this.worldView = view;
    }

    private double forceFunction(double x, double distance) {
        double multi = distance / this.AVOID_OBSTACLE_MIN_DISTANCE;
        if (x < -this.AVOID_OBSTACLE_FUNCTION || x > this.AVOID_OBSTACLE_FUNCTION) {
            return 0.0;
        }
        if (x < 0.0) {
            return (-this.AVOID_OBSTACLE_FUNCTION - x) * multi;
        }
        return (this.AVOID_OBSTACLE_FUNCTION - x) * multi;
    }

    public Location[] adjustLocations(Location[] moveLocation) {
        Player player = this.getNearestPlayer();
        if (player == null) {
            return moveLocation;
        }
        if (player.getLocation().getPoint3d().distance(this.getAgentInfo().getLocation().getPoint3d()) > this.AVOID_OBSTACLE_MIN_DISTANCE) {
            return moveLocation;
        }
        if (moveLocation[0] == null) {
            return moveLocation;
        }
        Location[] result = new Location[2];
        Location location = this.getAgentInfo().getLocation();
        Velocity velocity = new Velocity(moveLocation[0].x - location.x, moveLocation[0].y - location.y, moveLocation[0].z - location.z);
        Vector3d runningVector = velocity.getVector3d();
        runningVector.normalize();
        Point2D force = Algeb.rotate(Algeb.projection(runningVector), Algeb.rad(90.0));
        Point2D[] forces = new Point2D[2];
        forces[0] = Algeb.multi(Algeb.projection(runningVector), this.AVOID_OBSTACLE_RUN_VECTOR_LENGTH);
        double distance = Algeb.distanceFromRunningVector(location, velocity, player.getLocation());
        double multi = this.forceFunction(distance, location.getPoint3d().distance(player.getLocation().getPoint3d()));
        forces[1] = Algeb.multi(force, multi * this.AVOID_OBSTACLE_FUNCTION_MULTI);
        Point2D sum = Algeb.vectorSum(forces);
        result[0] = new Location(location.getX() + sum.getX(), location.getY() + sum.getY(), location.getZ());
        forces[0] = Algeb.multi(Algeb.projection(runningVector), this.AVOID_OBSTACLE_RUN_VECTOR_LENGTH * 2.0);
        sum = Algeb.vectorSum(forces);
        result[1] = new Location(location.getX() + sum.getX(), location.getY() + sum.getY(), location.getZ());
        return result;
    }

    public Player getNearestPlayer() {
        double dist = Double.MAX_VALUE;
        Player result = null;
        for (Player plr : this.worldView.getAll(Player.class).values()) {
            double distTmp;
            if (!plr.isVisible() || !((distTmp = plr.getLocation().getDistance(this.getAgentInfo())) < dist)) continue;
            dist = distTmp;
            result = plr;
        }
        return result;
    }

    public NavPoint findNearestNavPoint(Location place) {
        NavPoint winner = null;
        Collection<NavPoint> navPoints = this.getWorldView().getAll(NavPoint.class).values();
        for (NavPoint point : navPoints) {
            if (winner == null) {
                winner = point;
                continue;
            }
            if (!(winner.getLocation().getDistance(place) > point.getLocation().getDistance(place))) continue;
            winner = point;
        }
        return winner;
    }

    private AbstractWorldView getWorldView() {
        return (AbstractWorldView)this.worldView;
    }

    private Location getAgentInfo() {
        return this.worldView.getSingle(Self.class).getLocation();
    }

    public Double getNearestPlayerDistance() {
        if (this.getNearestPlayer() != null) {
            return this.getAgentInfo().getDistance(this.getNearestPlayer().getLocation());
        }
        return Double.MAX_VALUE;
    }
}

