/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.steering;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UTPathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.steering.AbstractUT2004SteeringExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.steering.AgentSteeringUtils;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;

public class AgentSteeringExecutor
extends AbstractUT2004SteeringExecutor {
    protected IWorldObjectEventListener<Player, WorldObjectUpdatedEvent<Player>> playerListener;
    private AgentSteeringUtils agentSteeringUtils;

    public AgentSteeringExecutor(IWorldView worldView, UTPathExecutor executor) {
        super(worldView, executor);
        this.agentSteeringUtils = new AgentSteeringUtils(worldView);
    }

    @Override
    protected void registerListeners() {
        this.playerListener = new IWorldObjectEventListener<Player, WorldObjectUpdatedEvent<Player>>(){

            @Override
            public void notify(WorldObjectUpdatedEvent<Player> event) {
                if (AgentSteeringExecutor.this.agentSteeringUtils.getNearestPlayerDistance() < 500.0) {
                    AgentSteeringExecutor.this.flag.setFlag(30);
                } else {
                    AgentSteeringExecutor.this.flag.setFlag(0);
                }
            }
        };
        this.worldView.addObjectListener(Player.class, WorldObjectUpdatedEvent.class, this.playerListener);
    }

    @Override
    public boolean execute() {
        ((UTPathExecutor)this.executor).logInfo("---- AGENT STEERING ---- EXECUTE");
        Location[] locations = new Location[2];
        Location location = locations[0] = ((UTPathExecutor)this.executor).getNextPathElement() == null ? null : ((ILocated)((UTPathExecutor)this.executor).getNextPathElement()).getLocation();
        if (((UTPathExecutor)this.executor).getNextPathElement() != null && ((UTPathExecutor)this.executor).getNextPathElement(1) != null) {
            locations[1] = ((ILocated)((UTPathExecutor)this.executor).getNextPathElement(1)).getLocation();
        }
        ((UTPathExecutor)this.executor).logInfo("---- AGENT STEERING ---- locations " + locations);
        Location[] newLocations = this.agentSteeringUtils.adjustLocations(locations);
        if (newLocations.length > 1) {
            ((UTPathExecutor)this.executor).moveTo(newLocations[0], newLocations[1]);
        } else {
            ((UTPathExecutor)this.executor).moveTo(newLocations[0]);
        }
        ((UTPathExecutor)this.executor).logInfo("---- AGENT STEERING ---- ADJUSTED locations " + newLocations);
        return true;
    }
}

