/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.steering;

import cz.cuni.amis.pogamut.base.agent.navigation.steering.AbstractSteeringExecutor;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UTPathExecutor;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;

public abstract class AbstractUT2004SteeringExecutor
extends AbstractSteeringExecutor<UTPathExecutor> {
    protected int MAX_BEGIN_COUNT_FOR_ERROR = 11;
    protected Location lastAgentPosition;
    protected int beginCount = 0;
    protected boolean executing = false;
    public static final int MAX_PRIORITY_GENERAL_STEERING = 5;
    public static final int MAX_PRIORITY_AGENT_STEERING = 30;
    public static final int MAX_PRIORITY_HIT_SOMETHING_STEERING = 20;
    public static final int MAX_PRIORITY_LIFT_STEERING = 25;
    public static final int MAX_PRIORITY_DOOR_STEERING = 36;
    public static final int MAX_PRIORITY_TELEPORTER_STEERING = 36;
    public static final int MAX_PRIORITY_PROJECTILE_STEERING = 50;
    private IWorldEventListener<BeginMessage> beginListener;
    private IWorldEventListener<BotKilled> killedListener;

    public AbstractUT2004SteeringExecutor(IWorldView worldView, UTPathExecutor executor) {
        super(worldView, executor);
    }

    @Override
    protected void registerListeners() {
        super.registerListeners();
        this.beginListener = new IWorldEventListener<BeginMessage>(){

            @Override
            public void notify(BeginMessage event) {
                AbstractUT2004SteeringExecutor.this.beginMessageEvent();
            }
        };
        this.worldView.addEventListener(BeginMessage.class, this.beginListener);
        this.killedListener = new IWorldEventListener<BotKilled>(){

            @Override
            public void notify(BotKilled event) {
                AbstractUT2004SteeringExecutor.this.afterKillEvent();
            }
        };
        this.worldView.addEventListener(BotKilled.class, this.killedListener);
    }

    private void afterKillEvent() {
        this.restartSteeringExecutorState();
        this.processKillEvent();
    }

    protected void restartSteeringExecutorState() {
        this.flag.setFlag(0);
    }

    protected void processKillEvent() {
    }

    protected void beginMessageEvent() {
    }

    protected String getExceptionMessage() {
        return "Steering executor " + this.getClass().getSimpleName() + " timeouted";
    }

    protected IAct getCommandSerializer() {
        return ((UTPathExecutor)this.executor).getCommandSerializer();
    }

    protected void log(String s) {
        ((UTPathExecutor)this.executor).log(s);
    }

    protected Location getAgentLocation() {
        if (this.worldView.getSingle(Self.class) != null) {
            return new Location(this.worldView.getSingle(Self.class).getLocation());
        }
        return null;
    }

    @Override
    public boolean execute() {
        this.executing = true;
        this.beginCount = 0;
        this.lastAgentPosition = this.getAgentLocation();
        return true;
    }

    protected void terminate() {
        this.executing = false;
        this.beginCount = 0;
        this.flag.setFlag(0);
    }
}

