/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall;

import cz.cuni.amis.pogamut.base.agent.navigation.AbstractPathHandle;
import cz.cuni.amis.pogamut.base.agent.navigation.PathHandle;
import cz.cuni.amis.pogamut.base.agent.navigation.PathNotConstructable;
import cz.cuni.amis.pogamut.base.agent.navigation.PathPlanner;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallMap;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.utils.IFilter;
import java.util.ArrayList;
import java.util.List;

public class FloydWarshallPathPlanner
implements PathPlanner<ILocated, ILocated> {
    UT2004Bot bot;
    FloydWarshallMap map;
    List<NavPoint> navPoints = null;

    public FloydWarshallPathPlanner(UT2004Bot bot) {
        this.bot = bot;
        this.map = new FloydWarshallMap(bot);
        if (bot.getWorldView().getAll(NavPoint.class).size() != 0) {
            this.navPoints = new ArrayList<NavPoint>(bot.getWorldView().getAll(NavPoint.class).values());
            this.map.performFloydWarshall(this.navPoints);
        }
    }

    @Override
    public PathHandle<ILocated> computePath(final ILocated to) throws PathNotConstructable {
        if (this.navPoints == null) {
            this.navPoints = new ArrayList<NavPoint>(this.bot.getWorldView().getAll(NavPoint.class).values());
        }
        NavPoint nearestToTarget = DistanceUtils.getNearest(this.navPoints, to);
        NavPoint nearestToBot = DistanceUtils.getNearestFiltered(this.navPoints, this.bot.getLocation(), new IFilter<NavPoint>(){

            @Override
            public boolean isAccepted(NavPoint object) {
                return object.isReachable();
            }
        });
        if (nearestToBot == null) {
            nearestToBot = DistanceUtils.getNearest(this.navPoints, this.bot.getLocation());
        }
        List<NavPoint> navPoints = this.map.getPath(nearestToBot, nearestToTarget);
        ArrayList<ILocated> path = new ArrayList<ILocated>();
        if (navPoints == null) {
            return null;
        }
        path.addAll(navPoints);
        path.add(new Location(to.getLocation()));
        return new AbstractPathHandle<ILocated>(path, true){

            @Override
            public String getTargetDescription() {
                return to.toString();
            }
        };
    }
}

