/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.utils;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TabooSet<T> {
    private Map<T, Double> taboo = new HashMap<T, Double>();
    private double time;
    BeginMessageListener beginMessageListener;

    public void add(T item) {
        this.taboo.put(item, -1.0);
    }

    public void add(T item, double timeout) {
        this.taboo.put(item, this.time + timeout);
    }

    public void remove(T item) {
        this.taboo.remove(item);
    }

    public boolean isTaboo(T item) {
        if (this.taboo.containsKey(item)) {
            double tabuTime = this.taboo.get(item);
            if (tabuTime < 0.0) {
                return true;
            }
            if (tabuTime < this.time) {
                this.taboo.remove(item);
                return false;
            }
            return true;
        }
        return false;
    }

    public Set<T> filter(Collection<T> collection) {
        HashSet<T> set = new HashSet<T>();
        for (T t : collection) {
            if (this.isTaboo(t)) continue;
            set.add(t);
        }
        return set;
    }

    public void clear() {
        this.taboo.clear();
    }

    public double getTime() {
        return this.time;
    }

    public TabooSet(UT2004Bot bot) {
        this.beginMessageListener = new BeginMessageListener(bot.getWorldView());
    }

    private class BeginMessageListener
    implements IWorldEventListener<BeginMessage> {
        public BeginMessageListener(IWorldView worldView) {
            worldView.addEventListener(BeginMessage.class, this);
        }

        @Override
        public void notify(BeginMessage event) {
            TabooSet.this.time = event.getTime();
        }
    }
}

