/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.sensor;

import cz.cuni.amis.pogamut.base.agent.module.SensorModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.Rotation;
import cz.cuni.amis.pogamut.base3d.worldview.object.Velocity;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerScore;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.TeamScore;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.VolumeChanged;
import cz.cuni.amis.utils.NullCheck;
import java.util.logging.Logger;

public class AgentInfo
extends SensorModule<UT2004Bot> {
    public static final String NONE_WEAPON_ID = "None";
    public static final int TEAM_RED = 0;
    public static final int TEAM_BLUE = 1;
    public static final int TEAM_GREEN = 2;
    public static final int TEAM_GOLD = 3;
    public static final int TEAM_NONE = 255;
    public static final double AT_LOCATION_EPSILON = 120.0;
    public static final double IS_FACING_ANGLE = 6.0;
    Self self = null;
    int suicides = 0;
    int kills = 0;
    InitedMessage lastInitedMessage = null;
    PlayerScore lastPlayerScore = null;
    TeamScore lastTeamScore = null;
    VolumeChanged lastVolumeChanged = null;
    ConfigChange lastConfig = null;
    BotKilledListener botKilledListener;
    PlayerKilledListener playerKilledListener;
    private InitedMessageListener initedMessageListener;
    private PlayerScoreListener playerScoreListener;
    private TeamScoreListener teamScoreListener;
    private VolumeChangedListener volumeChangedListener;
    private SelfListener selfListener;
    private ConfigChangeListener configChangeListener;
    public Game game;

    public UnrealId getId() {
        if (this.self == null) {
            return null;
        }
        return this.self.getId();
    }

    public String getName() {
        if (this.self == null) {
            return null;
        }
        return this.self.getName();
    }

    public Integer getTeam() {
        if (this.self == null) {
            return null;
        }
        return this.self.getTeam();
    }

    public boolean isEnemy(int team) {
        return team == 255 || team != this.getTeam();
    }

    public boolean isEnemy(Player player) {
        return this.isEnemy(player.getTeam());
    }

    public boolean isFriend(int team) {
        return team == this.getTeam();
    }

    public boolean isFriend(Player player) {
        return this.isFriend(player.getTeam());
    }

    public Location getLocation() {
        if (this.self == null) {
            return null;
        }
        return this.self.getLocation();
    }

    public boolean atLocation(Location location) {
        return this.atLocation(location, 120.0);
    }

    public boolean atLocation(Location location, double epsilon) {
        if (location == null || this.getLocation() == null) {
            return false;
        }
        return this.getLocation().getPoint3d().distance(location.getPoint3d()) < epsilon;
    }

    public Double getDistance(Location location) {
        if (this.self == null) {
            return null;
        }
        return this.self.getLocation().getDistance(location);
    }

    public Rotation getRotation() {
        if (this.self == null) {
            return null;
        }
        return this.self.getRotation();
    }

    public Velocity getVelocity() {
        if (this.self == null) {
            return null;
        }
        return this.self.getVelocity();
    }

    public Boolean isMoving() {
        if (this.getVelocity() == null) {
            return null;
        }
        return !this.getVelocity().isZero();
    }

    public Boolean isCrouched() {
        if (this.self == null) {
            return null;
        }
        return this.self.isCrouched();
    }

    public Boolean isWalking() {
        if (this.self == null) {
            return null;
        }
        return this.self.isWalking();
    }

    public Boolean isFacing(ILocated location) {
        Location agentFaceVector;
        if (location == null || this.getRotation() == null) {
            return null;
        }
        Location directionVector = location.getLocation().sub(this.getLocation()).getNormalized();
        if (Math.acos(directionVector.dot(agentFaceVector = this.getRotation().toLocation().getNormalized())) <= Math.toRadians(6.0)) {
            return true;
        }
        return false;
    }

    public Boolean isFacing(ILocated location, double angle) {
        Location agentFaceVector;
        if (location == null || this.getRotation() == null) {
            return null;
        }
        Location directionVector = location.getLocation().sub(this.getLocation()).getNormalized();
        if (Math.acos(directionVector.dot(agentFaceVector = this.getRotation().toLocation().getNormalized())) <= Math.toRadians(angle)) {
            return true;
        }
        return false;
    }

    public Location getFloorLocation() {
        if (this.self == null) {
            return null;
        }
        return this.self.getFloorLocation();
    }

    public Boolean isTouchingGround() {
        if (this.getLocation() == null || this.getFloorLocation() == null) {
            return null;
        }
        double d = this.getLocation().z - this.getFloorLocation().z;
        int n = this.isCrouched() != false ? 50 : 80;
        if (d < (double)n) {
            return true;
        }
        return false;
    }

    public Double getRemainingUDamageTime() {
        if (this.self == null) {
            return null;
        }
        return this.self.getUDamageTime() - this.getTime();
    }

    public Boolean hasUDamage() {
        if (this.getRemainingUDamageTime() == null) {
            return null;
        }
        if (this.getRemainingUDamageTime() > 0.0) {
            return true;
        }
        return false;
    }

    public Boolean hasInvisibility() {
        if (this.self == null) {
            return null;
        }
        return this.self.getCombo().equals("xGame.ComboInvis");
    }

    public Boolean hasFastFire() {
        if (this.self == null) {
            return null;
        }
        return this.self.getCombo().equals("xGame.ComboBerserk");
    }

    public Boolean hasRegeneration() {
        if (this.self == null) {
            return null;
        }
        return this.self.getCombo().equals("xGame.ComboDefensive");
    }

    public Boolean hasSpeed() {
        if (this.self == null) {
            return null;
        }
        return this.self.getCombo().equals("xGame.ComboSpeed");
    }

    public Integer getHealth() {
        if (this.self == null) {
            return null;
        }
        return this.self.getHealth();
    }

    public Boolean isHealthy() {
        if (this.getHealth() == null || this.game == null) {
            return null;
        }
        if (this.getHealth() >= this.game.getFullHealth()) {
            return true;
        }
        return false;
    }

    public Boolean isSuperHealthy() {
        if (this.getHealth() == null || this.game == null) {
            return null;
        }
        if (this.getHealth() >= this.game.getMaxHealth()) {
            return true;
        }
        return false;
    }

    public Integer getArmor() {
        if (this.self == null) {
            return null;
        }
        return this.self.getArmor();
    }

    public Boolean hasArmor() {
        if (this.getArmor() == null) {
            return null;
        }
        if (this.getArmor() >= this.game.getMaxArmor()) {
            return true;
        }
        return false;
    }

    public Integer getLowArmor() {
        if (this.self == null) {
            return null;
        }
        return this.self.getSmallArmor();
    }

    public Boolean hasLowArmor() {
        if (this.getLowArmor() == null || this.game == null) {
            return null;
        }
        if (this.getLowArmor() >= this.game.getMaxLowArmor()) {
            return true;
        }
        return false;
    }

    public Integer getHighArmor() {
        if (this.self == null) {
            return null;
        }
        return this.self.getArmor() - this.self.getSmallArmor();
    }

    public Boolean hasHighArmor() {
        if (this.getHighArmor() == null) {
            return null;
        }
        if (this.getHighArmor() >= this.game.getMaxHighArmor()) {
            return true;
        }
        return false;
    }

    public Integer getAdrenaline() {
        if (this.self == null) {
            return null;
        }
        return this.self.getAdrenaline();
    }

    public Boolean isAdrenalineSufficient() {
        if (this.getAdrenaline() == null) {
            return null;
        }
        if (this.getAdrenaline() >= this.game.getTargetAdrenaline()) {
            return true;
        }
        return false;
    }

    public Boolean isAdrenalineFull() {
        if (this.getAdrenaline() == null) {
            return null;
        }
        if (this.getAdrenaline() >= this.game.getMaxAdrenaline()) {
            return true;
        }
        return false;
    }

    public UnrealId getCurrentWeapon() {
        if (this.self == null) {
            return null;
        }
        return this.self.getWeapon();
    }

    public Boolean hasWeapon() {
        if (this.self == null) {
            return null;
        }
        return !this.self.getWeapon().getStringId().equalsIgnoreCase(NONE_WEAPON_ID);
    }

    public Integer getCurrentAmmo() {
        if (this.self == null) {
            return null;
        }
        return this.self.getPrimaryAmmo();
    }

    public Integer getCurrentSecondaryAmmo() {
        if (this.self == null) {
            return null;
        }
        return this.self.getSecondaryAmmo();
    }

    public Boolean isShooting() {
        if (this.self == null) {
            return null;
        }
        return this.self.isShooting();
    }

    public Boolean isPrimaryShooting() {
        if (this.self == null) {
            return null;
        }
        if (this.isShooting().booleanValue() && !this.isSecondaryShooting().booleanValue()) {
            return true;
        }
        return false;
    }

    public Boolean isSecondaryShooting() {
        if (this.self == null) {
            return null;
        }
        return this.self.isAltFiring();
    }

    public int getKills() {
        return this.kills;
    }

    public int getDeaths() {
        return this.lastPlayerScore.getDeaths();
    }

    public int getSuicides() {
        return this.suicides;
    }

    public int getScore() {
        return this.lastPlayerScore.getScore();
    }

    public int getTeamScore() {
        if (this.lastTeamScore == null) {
            return 0;
        }
        return this.lastTeamScore.getScore();
    }

    public Velocity getCurrentZoneVelocity() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.getZoneVelocity();
    }

    public Velocity getCurrentZoneGravity() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.getZoneGravity();
    }

    public Double getCurrentVolumeGroundFriction() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.getGroundFriction();
    }

    public Double getCurrentVolumeFluidFriction() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.getFluidFriction();
    }

    public Double _getCurrentVolumeTerminalVelocity() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.getTerminalVelocity();
    }

    public Boolean isCurrentVolumeWater() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.isWaterVolume();
    }

    public Boolean isCurrentVolumePainCausing() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.isPainCausing();
    }

    public Double getCurrentVolumeDamagePerSec() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.getDamagePerSec();
    }

    public Boolean isCurrentVolumeDestructive() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.isDestructive();
    }

    public String getCurrentVolumeDamageType() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.getDamageType();
    }

    public Boolean isCurrentVolumeBanningInventory() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.isNoInventory();
    }

    public Boolean isCurrentVolumeAffectingProjectiles() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.isMoveProjectiles();
    }

    public Boolean isCurrentZoneNeutral() {
        if (this.lastVolumeChanged == null) {
            return null;
        }
        return this.lastVolumeChanged.isNeutralZone();
    }

    public Double getDamageScaling() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getDamageScaling();
    }

    public Double getBaseSpeed() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getGroundSpeed();
    }

    public Double getAirSpeed() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getAirSpeed();
    }

    public Double getLadderSpeed() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getLadderSpeed();
    }

    public Double getWaterSpeed() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getWaterSpeed();
    }

    public Double getFallSpeed() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getMaxFallSpeed();
    }

    public Double getDodgeSpeedFactor() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getDodgeSpeedFactor();
    }

    public Double getAccelerationRate() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getAccelRate();
    }

    public Double getAirControl() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getAirControl();
    }

    public Double getJumpZBoost() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getJumpZ();
    }

    public Double getDodgeZBoost() {
        if (this.lastInitedMessage == null) {
            return null;
        }
        return this.lastInitedMessage.getDodgeSpeedZ();
    }

    public Double getTime() {
        if (this.game == null || this.game.getTime() == null) {
            return null;
        }
        return this.game.getTime();
    }

    public ConfigChange getConfig() {
        return this.lastConfig;
    }

    public NavPoint getNearestNavPoint() {
        if (this.getLocation() == null) {
            return null;
        }
        return DistanceUtils.getNearest(((UT2004Bot)this.agent).getWorldView().getAll(NavPoint.class).values(), this.getLocation());
    }

    public NavPoint getNearestVisibleNavPoint() {
        if (this.getLocation() == null) {
            return null;
        }
        return DistanceUtils.getNearestVisible(((UT2004Bot)this.agent).getWorldView().getAll(NavPoint.class).values(), this.getLocation());
    }

    public Item getNearestItem() {
        if (this.getLocation() == null) {
            return null;
        }
        return DistanceUtils.getNearest(((UT2004Bot)this.agent).getWorldView().getAll(Item.class).values(), this.getLocation());
    }

    public Item getNearestVisibleItem() {
        if (this.getLocation() == null) {
            return null;
        }
        return DistanceUtils.getNearestVisible(((UT2004Bot)this.agent).getWorldView().getAll(Item.class).values(), this.getLocation());
    }

    public Player getNearestPlayer() {
        if (this.getLocation() == null) {
            return null;
        }
        return DistanceUtils.getNearest(((UT2004Bot)this.agent).getWorldView().getAll(Player.class).values(), this.getLocation());
    }

    public Player getNearestVisiblePlayer() {
        if (this.getLocation() == null) {
            return null;
        }
        return DistanceUtils.getNearestVisible(((UT2004Bot)this.agent).getWorldView().getAll(Player.class).values(), this.getLocation());
    }

    public Self getSelf() {
        return this.self;
    }

    public AgentInfo(UT2004Bot bot) {
        this(bot, new Game(bot), null);
    }

    public AgentInfo(UT2004Bot bot, Game game) {
        this(bot, game, null);
    }

    public AgentInfo(UT2004Bot bot, Game game, Logger log) {
        super(bot, log);
        this.game = game;
        NullCheck.check(this.game, "game");
        this.selfListener = new SelfListener(this.worldView);
        this.initedMessageListener = new InitedMessageListener(this.worldView);
        this.playerScoreListener = new PlayerScoreListener(this.worldView);
        this.teamScoreListener = new TeamScoreListener(this.worldView);
        this.volumeChangedListener = new VolumeChangedListener(this.worldView);
        this.botKilledListener = new BotKilledListener(this.worldView);
        this.playerKilledListener = new PlayerKilledListener(this.worldView);
        this.configChangeListener = new ConfigChangeListener(this.worldView);
    }

    @Override
    protected void start() {
        super.start();
        this.self = null;
        this.suicides = 0;
        this.kills = 0;
        this.lastInitedMessage = null;
        this.lastPlayerScore = null;
        this.lastTeamScore = null;
        this.lastVolumeChanged = null;
        this.lastConfig = null;
    }

    private class BotKilledListener
    implements IWorldEventListener<BotKilled> {
        public BotKilledListener(IWorldView worldView) {
            worldView.addEventListener(BotKilled.class, this);
        }

        @Override
        public void notify(BotKilled event) {
            if (AgentInfo.this.self == null) {
                return;
            }
            if (event.getKiller() == null || event.getKiller().equals(AgentInfo.this.getId())) {
                ++AgentInfo.this.suicides;
            }
        }
    }

    private class ConfigChangeListener
    implements IWorldObjectEventListener<ConfigChange, IWorldObjectEvent<ConfigChange>> {
        private IWorldView worldView;

        public ConfigChangeListener(IWorldView worldView) {
            worldView.addObjectListener(ConfigChange.class, WorldObjectFirstEncounteredEvent.class, this);
            this.worldView = worldView;
        }

        @Override
        public void notify(IWorldObjectEvent<ConfigChange> event) {
            AgentInfo.this.lastConfig = event.getObject();
        }
    }

    private class InitedMessageListener
    implements IWorldObjectEventListener<InitedMessage, WorldObjectUpdatedEvent<InitedMessage>> {
        @Override
        public void notify(WorldObjectUpdatedEvent<InitedMessage> event) {
            AgentInfo.this.lastInitedMessage = (InitedMessage)event.getObject();
        }

        public InitedMessageListener(IWorldView worldView) {
            worldView.addObjectListener(InitedMessage.class, WorldObjectUpdatedEvent.class, this);
        }
    }

    private class PlayerKilledListener
    implements IWorldEventListener<PlayerKilled> {
        public PlayerKilledListener(IWorldView worldView) {
            worldView.addEventListener(PlayerKilled.class, this);
        }

        @Override
        public void notify(PlayerKilled event) {
            if (AgentInfo.this.self == null) {
                return;
            }
            if (event.getKiller() != null && event.getKiller().equals(AgentInfo.this.getId())) {
                ++AgentInfo.this.kills;
            }
        }
    }

    private class PlayerScoreListener
    implements IWorldEventListener<PlayerScore> {
        @Override
        public void notify(PlayerScore event) {
            AgentInfo.this.lastPlayerScore = event;
        }

        public PlayerScoreListener(IWorldView worldView) {
            worldView.addEventListener(PlayerScore.class, this);
        }
    }

    private class SelfListener
    implements IWorldObjectEventListener<Self, WorldObjectFirstEncounteredEvent<Self>> {
        private IWorldView worldView;

        public SelfListener(IWorldView worldView) {
            this.worldView = worldView;
            worldView.addObjectListener(Self.class, WorldObjectFirstEncounteredEvent.class, this);
        }

        @Override
        public void notify(WorldObjectFirstEncounteredEvent<Self> event) {
            AgentInfo.this.self = (Self)event.getObject();
        }
    }

    private class TeamScoreListener
    implements IWorldObjectEventListener<TeamScore, WorldObjectUpdatedEvent<TeamScore>> {
        public TeamScoreListener(IWorldView worldView) {
            worldView.addEventListener(TeamScore.class, this);
        }

        @Override
        public void notify(WorldObjectUpdatedEvent<TeamScore> event) {
            AgentInfo.this.lastTeamScore = (TeamScore)event.getObject();
        }
    }

    private class VolumeChangedListener
    implements IWorldEventListener<VolumeChanged> {
        @Override
        public void notify(VolumeChanged event) {
            AgentInfo.this.lastVolumeChanged = event;
        }

        public VolumeChangedListener(IWorldView worldView) {
            worldView.addEventListener(VolumeChanged.class, this);
        }
    }
}

