/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.logic;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.exceptions.AgentException;
import cz.cuni.amis.pogamut.base.agent.module.IAgentLogic;
import cz.cuni.amis.pogamut.base.agent.module.LogicModule;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReact;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReactOnce;
import cz.cuni.amis.pogamut.base.communication.worldview.react.ObjectEventReact;
import cz.cuni.amis.pogamut.base.communication.worldview.react.ObjectEventReactOnce;
import cz.cuni.amis.pogamut.base.component.bus.event.BusAwareCountDownLatch;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.exception.ComponentCantStartException;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GamePaused;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameResumed;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class UT2004BotLogic<BOT extends UT2004Bot>
extends LogicModule<BOT> {
    private EventReact<GamePaused> pauseReaction;
    private EventReact<GameResumed> resumeReaction;
    private ObjectEventReact<GameInfo, ?> gameInfoReaction;
    private EventReact<EndMessage> endReaction;
    private BusAwareCountDownLatch latch;

    @Inject
    public UT2004BotLogic(BOT agent, IAgentLogic logic) {
        this(agent, logic, (Logger)null, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add(((UT2004Bot)agent).getWorldView()));
    }

    public UT2004BotLogic(BOT agent, IAgentLogic logic, Logger log) {
        this(agent, logic, log, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add(((UT2004Bot)agent).getWorldView()));
    }

    public UT2004BotLogic(BOT agent, IAgentLogic logic, Logger log, ComponentDependencies dependencies) {
        super(agent, logic, log, dependencies);
        this.pauseReaction = new EventReact<GamePaused>(GamePaused.class, ((UT2004Bot)agent).getWorldView()){

            @Override
            protected void react(GamePaused event) {
                UT2004BotLogic.this.controller.manualPause("Game paused.");
            }
        };
        this.resumeReaction = new EventReact<GameResumed>(GameResumed.class, ((UT2004Bot)agent).getWorldView()){

            @Override
            protected void react(GameResumed event) {
                UT2004BotLogic.this.controller.manualResume("Game resumed.");
            }
        };
        this.gameInfoReaction = new ObjectEventReactOnce<GameInfo, IWorldObjectEvent<GameInfo>>((WorldObjectId)GameInfo.GameInfoId, ((UT2004Bot)agent).getWorldView()){

            @Override
            protected void react(IWorldObjectEvent<GameInfo> event) {
                if (event.getObject().isBotsPaused() || event.getObject().isGamePaused()) {
                    UT2004BotLogic.this.controller.manualPause("Bot launched into paused game.");
                }
            }
        };
        this.endReaction = new EventReactOnce<EndMessage>(EndMessage.class, ((UT2004Bot)agent).getWorldView()){

            @Override
            protected void react(EndMessage event) {
                UT2004BotLogic.this.latch.countDown();
            }
        };
    }

    @Override
    protected void logicLatch(String threadName) {
        super.logicLatch(threadName);
        this.log.fine(String.valueOf(threadName) + ": Waiting for the first End message.");
        if (!this.latch.await(60L, TimeUnit.SECONDS)) {
            throw new ComponentCantStartException("End message was not received in 60secs.", this);
        }
        this.log.info(String.valueOf(threadName) + ": First END message received, starting logic cycles.");
    }

    @Override
    protected void start() throws AgentException {
        super.start();
        this.gameInfoReaction.enable();
        this.endReaction.enable();
        this.latch = new BusAwareCountDownLatch(1, ((UT2004Bot)this.agent).getEventBus(), ((UT2004Bot)this.agent).getWorldView().getComponentId());
    }
}

