/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.module.logic;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractEmbodiedAgent;
import cz.cuni.amis.pogamut.base.agent.module.IAgentLogic;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.command.ICommandListener;
import cz.cuni.amis.pogamut.base.communication.worldview.react.EventReact;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base3d.ILockableVisionWorldView;
import cz.cuni.amis.pogamut.ut2004.agent.module.logic.UT2004BotLogic;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Respawn;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import java.util.logging.Logger;

public class SyncUT2004BotLogic<BOT extends UT2004Bot<? extends ILockableVisionWorldView, ?, ?>>
extends UT2004BotLogic<BOT> {
    private EventReact<EndMessage> endReactionAfterRespawn;
    private int shouldExecuteLogicLatch = 0;
    private ICommandListener<Respawn> respawnListener = new ICommandListener<Respawn>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notify(Respawn event) {
            ICommandListener iCommandListener = SyncUT2004BotLogic.this.respawnListener;
            synchronized (iCommandListener) {
                SyncUT2004BotLogic.this.endReactionAfterRespawn.enable();
                SyncUT2004BotLogic.this.shouldExecuteLogicLatch = 2;
            }
        }
    };

    @Inject
    public SyncUT2004BotLogic(BOT agent, IAgentLogic logic) {
        this(agent, logic, (Logger)null, new ComponentDependencies(ComponentDependencyType.STARTS_AFTER).add(((UT2004Bot)agent).getWorldView()));
    }

    public SyncUT2004BotLogic(BOT agent, IAgentLogic logic, Logger log) {
        this(agent, logic, log, new ComponentDependencies(ComponentDependencyType.STARTS_AFTER).add(((UT2004Bot)agent).getWorldView()));
    }

    public SyncUT2004BotLogic(BOT agent, IAgentLogic logic, Logger log, ComponentDependencies dependencies) {
        super(agent, logic, log, dependencies);
        this.endReactionAfterRespawn = new EventReact<EndMessage>(EndMessage.class, ((UT2004Bot)agent).getWorldView()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void react(EndMessage event) {
                ICommandListener iCommandListener = SyncUT2004BotLogic.this.respawnListener;
                synchronized (iCommandListener) {
                    if (SyncUT2004BotLogic.this.shouldExecuteLogicLatch > 0) {
                        SyncUT2004BotLogic syncUT2004BotLogic = SyncUT2004BotLogic.this;
                        syncUT2004BotLogic.shouldExecuteLogicLatch = syncUT2004BotLogic.shouldExecuteLogicLatch - 1;
                    }
                }
            }
        };
        ((IAct)((AbstractEmbodiedAgent)agent).getAct()).addCommandListener(Respawn.class, this.respawnListener);
    }

    @Override
    protected void beforeLogic(String threadName) {
        super.beforeLogic(threadName);
        this.log.finest(String.valueOf(threadName) + ": Locking world view.");
        ((ILockableVisionWorldView)((UT2004Bot)this.agent).getWorldView()).lock();
        this.log.finer(String.valueOf(threadName) + ": World view locked.");
    }

    @Override
    protected void afterLogic(String threadName) {
        super.afterLogic(threadName);
        this.log.finest(String.valueOf(threadName) + ": Unlocking world view.");
        ((ILockableVisionWorldView)((UT2004Bot)this.agent).getWorldView()).unlock();
        this.log.finer(String.valueOf(threadName) + ": World view unlocked.");
    }

    @Override
    protected void afterLogicException(String threadName, Throwable e) {
        super.afterLogicException(threadName, e);
        if (((ILockableVisionWorldView)((UT2004Bot)this.agent).getWorldView()).isLocked()) {
            this.log.finest("Unlocking world view.");
            ((ILockableVisionWorldView)((UT2004Bot)this.agent).getWorldView()).unlock();
            this.log.finer("World view unlocked.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean shouldExecuteLogic() {
        ICommandListener<Respawn> iCommandListener = this.respawnListener;
        synchronized (iCommandListener) {
            block4: {
                if (this.shouldExecuteLogicLatch == 0) break block4;
                this.log.info("Respawn command sensed - waiting for the bot respawn to execute logic with correct world view state.");
                return false;
            }
            return true;
        }
    }
}

