/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.math;

import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.IViewable;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.utils.IFilter;
import java.util.Collection;

public class DistanceUtils {
    public static <T extends ILocated> T getNearest(Collection<T> locations, ILocated target) {
        ILocated nearest = null;
        Location targetLoc = target.getLocation();
        double minDistance = Double.MAX_VALUE;
        for (ILocated l : locations) {
            double d = l.getLocation().getDistance(targetLoc);
            if (!(d < minDistance)) continue;
            minDistance = d;
            nearest = l;
        }
        return (T)nearest;
    }

    public static <T extends ILocated> T getNearestFiltered(Collection<T> locations, ILocated target, IFilter<T> filter) {
        ILocated nearest = null;
        Location targetLoc = target.getLocation();
        double minDistance = Double.MAX_VALUE;
        for (ILocated l : locations) {
            double d;
            if (!filter.isAccepted(l) || !((d = l.getLocation().getDistance(targetLoc)) < minDistance)) continue;
            minDistance = d;
            nearest = l;
        }
        return (T)nearest;
    }

    public static <T extends ILocated> T getSecondNearest(Collection<T> locations, ILocated target) {
        ILocated secondNearest = null;
        ILocated nearest = null;
        Location targetLoc = target.getLocation();
        double closestDistance = Double.MAX_VALUE;
        double secondClosestDistance = Double.MAX_VALUE;
        for (ILocated l : locations) {
            double distance = Location.getDistance(l.getLocation(), targetLoc);
            if (distance < closestDistance) {
                secondClosestDistance = closestDistance;
                secondNearest = nearest;
                closestDistance = distance;
                nearest = l;
                continue;
            }
            if (!(distance < secondClosestDistance)) continue;
            secondClosestDistance = distance;
            secondNearest = l;
        }
        return (T)secondNearest;
    }

    public static <T extends IViewable> T getNearestVisible(Collection<T> locations, ILocated target) {
        IViewable nearest = null;
        Location targetLoc = target.getLocation();
        double minDistance = Double.MAX_VALUE;
        for (IViewable l : locations) {
            ILocated loc;
            double d;
            if (!l.isVisible() || !((d = (loc = (ILocated)((Object)l)).getLocation().getDistance(targetLoc)) < minDistance)) continue;
            minDistance = d;
            nearest = l;
        }
        return (T)nearest;
    }

    public static <T extends IViewable> T getSecondNearestVisible(Collection<T> locations, ILocated target) {
        IViewable secondNearest = null;
        IViewable nearest = null;
        Location targetLoc = target.getLocation();
        double closestDistance = Double.MAX_VALUE;
        double secondClosestDistance = Double.MAX_VALUE;
        for (IViewable l : locations) {
            if (!l.isVisible()) continue;
            ILocated loc = (ILocated)((Object)l);
            double distance = Location.getDistance(loc.getLocation(), targetLoc);
            if (distance < closestDistance) {
                secondClosestDistance = closestDistance;
                secondNearest = nearest;
                closestDistance = distance;
                nearest = l;
                continue;
            }
            if (!(distance < secondClosestDistance)) continue;
            secondClosestDistance = distance;
            secondNearest = l;
        }
        return (T)secondNearest;
    }
}

