/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging.marks;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import java.io.Serializable;
import java.util.Calendar;

public class LogMapMark
implements Serializable {
    private final String message;
    private final Location location;
    private final long created;
    private final long duration;
    private Type type;

    private LogMapMark(String message, Location location, long created, long duration, Type type) {
        this.message = message;
        this.location = new Location(location);
        this.created = created;
        this.duration = duration;
        this.type = type;
    }

    public static LogMapMark createFixedLengthEvent(String message, Location location, long duration) {
        return new LogMapMark(message, location, Calendar.getInstance().getTimeInMillis(), duration, Type.FIXED_DURATION);
    }

    public static LogMapMark createAgentFixedLengthEvent(String message, long duration) {
        return new LogMapMark(message, new Location(0.0, 0.0, 0.0), Calendar.getInstance().getTimeInMillis(), duration, Type.FIXED_DURATION);
    }

    public static LogMapMark createAgentVariableLengthEvent(String message) {
        return new LogMapMark(message, new Location(0.0, 0.0, 0.0), Calendar.getInstance().getTimeInMillis(), Integer.MAX_VALUE, Type.START_EVENT);
    }

    public static LogMapMark createVariableLengthEvent(String message, Location location) {
        return new LogMapMark(message, location, Calendar.getInstance().getTimeInMillis(), Integer.MAX_VALUE, Type.START_EVENT);
    }

    public Location getLocation(Location entityLoc) {
        return this.getLocation();
    }

    public boolean equals(Object aThat) {
        if (this == aThat) {
            return true;
        }
        if (!(aThat instanceof LogMapMark)) {
            return false;
        }
        LogMapMark second = (LogMapMark)aThat;
        return this.equalWithoutType(second) && this.getType() == second.getType();
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + (this.message != null ? this.message.hashCode() : 0);
        hash = 71 * hash + (this.location != null ? this.location.hashCode() : 0);
        hash = 71 * hash + (int)(this.created ^ this.created >>> 32);
        hash = 71 * hash + (int)(this.duration ^ this.duration >>> 32);
        return hash;
    }

    public String getMessage() {
        return this.message;
    }

    public Location getLocation() {
        return new Location(this.location);
    }

    public long getCreated() {
        return this.created;
    }

    public long getDuration() {
        return this.duration;
    }

    public Type getType() {
        return this.type;
    }

    public LogMapMark getEndMark() {
        if (this.getType() == Type.START_EVENT || this.getType() == Type.END_EVENT) {
            return new LogMapMark(this.message, this.location, this.created, this.duration, this.type);
        }
        throw new IllegalStateException("Mark is not in a state that can be changed to END_EVENT, it is in " + (Object)((Object)this.getType()));
    }

    public boolean equalWithoutType(LogMapMark second) {
        boolean durEqual;
        boolean msgEqual;
        LogMapMark first = this;
        boolean bl = first.getMessage() == null ? second.getMessage() == null : (msgEqual = first.getMessage().equals(second.getMessage()));
        boolean locEqual = first.getLocation() == null ? second.getLocation() == null : first.getLocation().equals(second.getLocation());
        boolean createdEqual = first.getCreated() == second.getCreated();
        boolean bl2 = durEqual = first.getDuration() == second.getDuration();
        return msgEqual && locEqual && createdEqual && durEqual;
    }

    public static enum Type {
        FIXED_DURATION,
        START_EVENT,
        END_EVENT;

    }
}

