/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.logging;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFormatter
extends Formatter {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
    private static String longestAgentName = "";
    private static String longestComponentName = "";
    private StringBuffer buffer = new StringBuffer(512);
    private boolean lineEnds;
    private IAgentId name = null;
    public static final String[] whitespaces = new String[]{"        ", "       ", "      ", "     ", "    ", "   ", "  ", " ", ""};

    public LogFormatter() {
        this(null, false);
    }

    public LogFormatter(boolean lineEnds) {
        this(null, lineEnds);
    }

    public LogFormatter(IAgentId agentId) {
        this(agentId, false);
    }

    public LogFormatter(IAgentId agentId, boolean lineEnds) {
        this.name = agentId;
        this.lineEnds = lineEnds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized String format(LogRecord record) {
        int i;
        Object n;
        this.buffer.delete(0, this.buffer.length());
        if (this.name != null) {
            n = this.name.getName().getFlag();
            if (n == null) {
                n = "null";
            }
            if (((String)n).length() > longestAgentName.length()) {
                StringBuffer longest = new StringBuffer();
                i = 0;
                while (i < ((String)n).length()) {
                    longest.append(" ");
                    ++i;
                }
                longestAgentName = longest.toString();
            }
            this.buffer.append("(");
            this.buffer.append((String)n);
            this.buffer.append(") ");
            int count = longestAgentName.length() - ((String)n).length();
            i = 0;
            while (i < count) {
                this.buffer.append(" ");
                ++i;
            }
        } else if (longestAgentName.length() > 0) {
            this.buffer.append("()");
            this.buffer.append(longestAgentName);
        } else {
            this.buffer.append("() ");
        }
        this.buffer.append("[");
        this.buffer.append(record.getLevel().toString());
        this.buffer.append("]");
        this.buffer.append(whitespaces[record.getLevel().toString().length()]);
        n = dateFormat;
        synchronized (n) {
            this.buffer.append(dateFormat.format(new Date(record.getMillis())));
        }
        this.buffer.append(" ");
        n = record.getLoggerName();
        if (n == null) {
            n = "null";
        }
        if (((String)n).length() > longestComponentName.length()) {
            StringBuffer longest = new StringBuffer();
            i = 0;
            while (i < ((String)n).length()) {
                longest.append(" ");
                ++i;
            }
            longestComponentName = longest.toString();
        }
        this.buffer.append("<");
        this.buffer.append((String)n);
        this.buffer.append("> ");
        int count = longestComponentName.length() - ((String)n).length();
        i = 0;
        while (i < count) {
            this.buffer.append(" ");
            ++i;
        }
        this.buffer.append(record.getMessage());
        if (this.lineEnds) {
            this.buffer.append("\r\n");
        }
        return this.buffer.toString();
    }
}

