/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.listener;

import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.utils.StopWatch;
import cz.cuni.amis.utils.listener.Event;
import cz.cuni.amis.utils.listener.IListener;
import cz.cuni.amis.utils.listener.ListenersMap;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Tokens;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import org.junit.Assert;
import org.junit.Test;

public class Test04_ListenersMap {
    private static final IToken[] TOKENS = new IToken[]{Tokens.get("token1"), Tokens.get("token2"), Tokens.get("token3")};
    private CountDownLatch latch;
    private boolean failure = false;

    @Test
    public void test() {
        AgentId agentId = new AgentId("Test06_ComponentBus");
        AgentLogger logger = new AgentLogger(agentId);
        logger.setLevel(Level.OFF);
        ListenersMap<Integer> listeners = new ListenersMap<Integer>();
        Thread[] threads = new Thread[32];
        int i = 0;
        while (i < threads.length) {
            threads[i] = new Thread(new ListenersManager(listeners, i + 1));
            ++i;
        }
        this.latch = new CountDownLatch(threads.length);
        StopWatch watch = new StopWatch();
        int i2 = 0;
        while (i2 < threads.length) {
            threads[i2].start();
            ++i2;
        }
        try {
            this.latch.await();
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Exception waiting for threads...");
        }
        System.out.println("Total time: " + watch.stopStr());
        if (this.failure) {
            Assert.fail((String)"Test failed due to previous exceptions.");
        }
        System.out.println("---/// TEST OK ///---");
    }

    public static void main(String[] args) {
        Test04_ListenersMap test = new Test04_ListenersMap();
        test.test();
    }

    private static class Event1
    implements Event {
        private Event1() {
        }
    }

    private static class Event2
    implements Event {
        private Event2() {
        }
    }

    private class ListenersManager
    implements Runnable {
        private Random random = new Random(System.currentTimeMillis());
        private int num;
        private int listenerNum = 0;
        private int notified = 0;
        private ListenersMap<Integer> listeners;
        private Map<IListener, Integer> myListeners = new HashMap<IListener, Integer>();

        private void addListener() {
            IListener<Event> listener = new IListener<Event>(){
                int lNum;
                {
                    ListenersManager listenersManager2 = ListenersManager.this;
                    int n = listenersManager2.listenerNum + 1;
                    listenersManager2.listenerNum = n;
                    this.lNum = n;
                }

                @Override
                public void notify(Event event) {
                    ListenersManager listenersManager = ListenersManager.this;
                    listenersManager.notified = listenersManager.notified + 1;
                }

                public String toString() {
                    return "Listener " + ListenersManager.this.num + "-" + this.lNum;
                }
            };
            int key = this.random.nextInt(10);
            this.myListeners.put(listener, key);
            this.listeners.add(key, listener);
            if (!this.listeners.isListening(key, listener)) {
                throw new RuntimeException("listener not added");
            }
            if (this.listeners.isListening(key + 1, listener)) {
                throw new RuntimeException("listener added under wrong key");
            }
            if (this.listeners.isListening(key - 1, listener)) {
                throw new RuntimeException("listener added under wrong key");
            }
        }

        private void removeListener() {
            if (this.myListeners.size() == 0) {
                return;
            }
            Iterator<Map.Entry<IListener, Integer>> iter = this.myListeners.entrySet().iterator();
            Map.Entry<IListener, Integer> entry = iter.next();
            IListener listener = entry.getKey();
            int key = entry.getValue();
            if (!this.listeners.isListening(listener)) {
                throw new RuntimeException("listeners has leaked the listener (not found)");
            }
            this.listeners.remove(key, listener);
            iter.remove();
            if (this.listeners.isListening(key, listener)) {
                throw new RuntimeException("listener not removed");
            }
        }

        private void event() {
            this.listeners.notify(this.random.nextInt(10), new IListener.Notifier<IListener>(new Event1()));
        }

        public ListenersManager(ListenersMap<Integer> listeners, int num) {
            this.listeners = listeners;
            this.num = num;
        }

        @Override
        public void run() {
            try {
                try {
                    StopWatch watch = new StopWatch();
                    this.addListener();
                    this.event();
                    int i = 0;
                    while (i < 1000) {
                        switch (this.random.nextInt(6)) {
                            case 0: {
                                try {
                                    Thread.sleep(2L);
                                }
                                catch (InterruptedException interruptedException) {}
                                break;
                            }
                            case 1: {
                                this.addListener();
                                break;
                            }
                            case 2: {
                                this.addListener();
                                break;
                            }
                            case 3: {
                                this.removeListener();
                                break;
                            }
                            case 4: {
                                this.event();
                                break;
                            }
                            case 5: {
                                this.event();
                            }
                        }
                        ++i;
                    }
                    System.out.println("Thread " + this.num + ": notified = " + this.notified + ".");
                    System.out.println("Thread " + this.num + ": 2000 operations took " + watch.stopStr());
                    Assert.assertTrue((String)("At least one notification of thread " + this.num + " listener must go through."), (this.notified > 0 ? 1 : 0) != 0);
                    while (this.myListeners.size() > 0) {
                        this.removeListener();
                    }
                }
                catch (Exception e) {
                    System.out.println("Thread " + this.num + ": " + e.getMessage());
                    e.printStackTrace();
                    Test04_ListenersMap.this.failure = true;
                    Test04_ListenersMap.this.latch.countDown();
                }
            }
            finally {
                Test04_ListenersMap.this.latch.countDown();
            }
        }
    }
}

