/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.utils.configuration;

import cz.cuni.amis.utils.configuration.PropertyProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class CustomPropertiesProvider
extends PropertyProvider {
    static final String resource = "PogamutPlatformCustom.properties";
    Properties properties = new Properties();
    File propFile;

    public CustomPropertiesProvider() {
        try {
            this.propFile = new File(resource);
            this.properties.load(new FileInputStream(this.propFile));
        }
        catch (FileNotFoundException e) {
            System.err.print("Custom property file not found in " + this.propFile.getAbsolutePath() + ".");
        }
        catch (IOException ex) {
            throw new RuntimeException("I/O exception while reading the custom Pogamut platform property file 'PogamutPlatformCustom.properties', absolute location '" + this.propFile.getAbsolutePath() + "'.", ex);
        }
    }

    @Override
    public String getProperty(String key) {
        return this.properties.getProperty(key);
    }

    @Override
    public int getPriority() {
        return 1000;
    }

    public String toString() {
        return "Custom properties were loaded from '" + this.propFile.getAbsolutePath() + "'.";
    }
}

