/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.factory.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.util.Modules;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.communication.mediator.IMediator;
import cz.cuni.amis.pogamut.base.communication.mediator.impl.Mediator;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEventOutput;
import cz.cuni.amis.pogamut.base.communication.translator.impl.WorldMessageTranslator;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldChangeEventInput;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.component.bus.ComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.guice.AdaptableProvider;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScope;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.guice.IAgentScope;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.utils.NullCheck;
import java.util.ArrayList;
import java.util.List;

public class GuiceAgentModule
extends AbstractModule {
    private IAgentScope agentScope;
    private AdaptableProvider<IAgentId> agentIdProvider = new AdaptableProvider<Object>(null);
    private List<Module> modules = new ArrayList<Module>();

    public GuiceAgentModule() {
        this.agentScope = this.createAgentScope();
        NullCheck.check(this.agentScope, "createAgentScope()");
        this.configureModules();
    }

    protected final void addModule(AbstractModule module) {
        this.modules.add((Module)module);
    }

    protected void configureModules() {
        this.addModule(new AbstractModule(){

            protected void configure() {
                this.bind(IComponentBus.class).to(ComponentBus.class);
                this.bind(IAgentId.class).toProvider((Provider)GuiceAgentModule.this.agentIdProvider);
                this.bind(IAgentLogger.class).to(AgentLogger.class);
                this.bind(IWorldChangeEventOutput.class).to(WorldMessageTranslator.class);
                this.bind(IMediator.class).to(Mediator.class);
                this.bind(IWorldChangeEventInput.class).to(IWorldView.class);
            }
        });
    }

    protected IAgentScope createAgentScope() {
        return new AgentScope();
    }

    public IAgentScope getAgentScope() {
        return this.agentScope;
    }

    public AdaptableProvider<IAgentId> getAgentNameProvider() {
        return this.agentIdProvider;
    }

    protected final void configure() {
        this.bindScope(AgentScoped.class, this.agentScope);
        if (this.modules.size() == 0) {
            throw new IllegalStateException("There is no module defined, nobody has ever called addModule() method to introduce new bindings for the module.");
        }
        Module actual = this.modules.get(0);
        int i = 1;
        while (i < this.modules.size()) {
            actual = Modules.override((Module[])new Module[]{actual}).with(new Module[]{this.modules.get(i)});
            ++i;
        }
        this.install(actual);
    }
}

