/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.stub;

import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.IComponentEvent;
import cz.cuni.amis.pogamut.base.component.stub.CheckEvent;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.token.IToken;
import cz.cuni.amis.utils.token.Token;
import cz.cuni.amis.utils.token.Tokens;
import java.util.LinkedList;
import java.util.Queue;
import junit.framework.Assert;

public class ManualCheckComponent
implements IComponent {
    private static int counter = 0;
    private Token token;
    private Queue<CheckEvent> expect = new LinkedList<CheckEvent>();
    private IComponentBus bus;
    private LogCategory log;

    public ManualCheckComponent(IAgentLogger logger, IComponentBus bus) {
        this(logger, bus, new CheckEvent[0]);
    }

    public ManualCheckComponent(IAgentLogger logger, IComponentBus bus, CheckEvent ... events) {
        this.token = Tokens.get("ManualCheckComponent" + counter++);
        this.log = logger.getCategory(this);
        NullCheck.check(this.log, "log initialization");
        this.expect(events);
        this.bus = bus;
        this.bus.register(this);
    }

    public void expect(CheckEvent ... events) {
        CheckEvent[] checkEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            CheckEvent event = checkEventArray[n2];
            this.expect(event);
            ++n2;
        }
    }

    public void expect(CheckEvent event) {
        this.expect.add(event);
    }

    public int getExpectSize() {
        return this.expect.size();
    }

    public void manualNotify(IComponentEvent<?> event) {
        this.log.info("Got event: " + event);
        if (this.expect.size() == 0) {
            throw new RuntimeException("No event expected, but " + event.getClass() + " from " + event.getSource() + " came.");
        }
        this.expect.poll().check(event);
    }

    @Override
    public IToken getComponentId() {
        return this.token;
    }

    public String toString() {
        return this.getComponentId().getToken();
    }

    public void checkExpectEmpty() {
        Assert.assertTrue((String)"should not expect any events", (this.getExpectSize() == 0 ? 1 : 0) != 0);
        this.log.info("Does not expecting any new events.");
    }
}

