/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.component.bus.event.impl;

import cz.cuni.amis.pogamut.base.component.IComponent;
import cz.cuni.amis.pogamut.base.component.bus.event.IFatalErrorEvent;
import cz.cuni.amis.pogamut.base.utils.Const;
import java.util.Arrays;

public class FatalErrorEvent<SOURCE extends IComponent>
implements IFatalErrorEvent<SOURCE> {
    protected Object origin;
    protected SOURCE component;
    protected String message;
    protected Throwable cause;
    protected StackTraceElement[] stackTrace;

    public FatalErrorEvent(SOURCE component, String message) {
        this.message = message;
        this.component = component;
        this.origin = this.origin;
        this.stackTrace();
    }

    public FatalErrorEvent(SOURCE component, String message, Throwable cause) {
        this.message = message;
        this.component = component;
        this.cause = cause;
        this.stackTrace();
    }

    public FatalErrorEvent(SOURCE component, Throwable cause) {
        this.message = cause.getMessage();
        this.component = component;
        this.cause = cause;
        this.stackTrace();
    }

    private void stackTrace() {
        Exception e = new Exception();
        this.stackTrace = e.getStackTrace();
        this.stackTrace = Arrays.copyOfRange(this.stackTrace, 2, this.stackTrace.length);
    }

    @Override
    public SOURCE getSource() {
        return this.component;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    protected String printStackStrace(StackTraceElement[] stackTraceToPrint, String indent) {
        StringBuffer sb = new StringBuffer();
        sb.append(indent);
        sb.append(stackTraceToPrint[0]);
        int i = 1;
        while (i < stackTraceToPrint.length) {
            sb.append(Const.NEW_LINE);
            sb.append(indent);
            sb.append(stackTraceToPrint[i]);
            ++i;
        }
        return sb.toString();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[source=" + this.getSource() + ", message=" + this.message + (this.cause == null ? "" : ", cause=" + this.cause) + "]";
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append("FatalErrorEvent[");
        sb.append(Const.NEW_LINE);
        sb.append("    Component=" + this.component);
        sb.append(Const.NEW_LINE);
        sb.append("    Message=" + this.message);
        sb.append(Const.NEW_LINE);
        if (this.cause != null) {
            sb.append("    Cause=" + this.cause);
            sb.append(Const.NEW_LINE);
            sb.append("    Cause stacktrace:");
            sb.append(Const.NEW_LINE);
            sb.append(this.printStackStrace(this.cause.getStackTrace(), "        "));
        } else {
            sb.append("    Stacktrace:");
            sb.append(Const.NEW_LINE);
            sb.append(this.printStackStrace(this.stackTrace, "        "));
            sb.append(Const.NEW_LINE);
            sb.append("]");
        }
        return sb.toString();
    }
}

