/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.worldview.stubs;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdateResult;
import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.WorldObjectId;
import cz.cuni.amis.pogamut.base.communication.worldview.stubs.AbstractObjectStub;
import cz.cuni.amis.utils.ClassUtils;
import java.lang.reflect.Field;
import junit.framework.Assert;

public class ObjectUpdatedEventStub
implements IWorldObjectUpdatedEvent {
    private AbstractObjectStub object;

    public ObjectUpdatedEventStub(AbstractObjectStub obj) {
        this.object = obj;
    }

    @Override
    public WorldObjectId getId() {
        return this.object.getId();
    }

    @Override
    public IWorldObjectUpdateResult update(IWorldObject obj) {
        if (obj == null) {
            return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.CREATED, this.object);
        }
        if (!obj.getClass().equals(this.object.getClass())) {
            throw new RuntimeException("Can not update object " + obj + " with infos from " + this.object + " as they are of different class.");
        }
        if (!this.getId().equals(obj.getId())) {
            throw new RuntimeException("Can not update object " + obj + " with infos from " + this.object + " as they are of different IDs.");
        }
        for (Field field : ClassUtils.getAllFields(obj.getClass(), false)) {
            field.setAccessible(true);
            if (field.getName().equalsIgnoreCase("id")) continue;
            try {
                field.set(obj, field.get(this.object));
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)"Failed to compare objects for equality...");
            }
        }
        return new IWorldObjectUpdateResult.WorldObjectUpdateResult(IWorldObjectUpdateResult.Result.UPDATED, obj);
    }

    public String toString() {
        return "ObjectUpdatedEvent[" + this.object + "]";
    }
}

