/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.communication.connection;

import cz.cuni.amis.pogamut.base.communication.connection.CommunicationTestCase;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import org.junit.Test;

public class Test01_Server
extends CommunicationTestCase {
    private String[] responses = new String[]{"Hello", "Bye"};

    @Override
    public String[] getResponses() {
        return this.responses;
    }

    @Test
    public void test() {
        Test01_Server.assertTrue((String)"server not started correctly", (boolean)this.getServer().consume("Server started"));
        Socket sock = null;
        try {
            sock = new Socket("127.0.0.1", this.getServer().getPort());
        }
        catch (UnknownHostException e) {
            Test01_Server.fail((String)e.getMessage());
        }
        catch (IOException e) {
            Test01_Server.fail((String)e.getMessage());
        }
        BufferedReader in = null;
        PrintWriter out = null;
        try {
            in = new BufferedReader(new InputStreamReader(sock.getInputStream()));
            out = new PrintWriter(sock.getOutputStream());
        }
        catch (IOException e) {
            Test01_Server.fail((String)e.getMessage());
        }
        out.println("get");
        out.flush();
        try {
            int i = 0;
            while (in.ready()) {
                if (i >= this.getResponses().length) {
                    Test01_Server.fail((String)"server sent too many response lines");
                }
                String line = in.readLine();
                Test01_Server.assertTrue((String)("wrong response, EXPECTED: " + this.getResponses()[i] + ", GOT: " + line), (boolean)line.equals(this.getResponses()[i++]));
            }
        }
        catch (IOException e) {
            Test01_Server.fail((String)e.getMessage());
        }
        out.println("quit");
        out.flush();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            in.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        out.close();
        try {
            sock.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        Test01_Server.assertTrue((String)"server didn't receive GET command", (boolean)this.getServer().consume("Received: get"));
        String[] stringArray = this.getResponses();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            Test01_Server.assertTrue((String)"server wrong reply", (boolean)this.getServer().consume("Sent: " + str));
            ++n2;
        }
        Test01_Server.assertTrue((String)"server didn't receive QUIT command", (boolean)this.getServer().consume("Received: quit"));
        Test01_Server.assertTrue((String)"server didn't terminate", (boolean)this.getServer().consume("Server terminated"));
        Test01_Server.assertTrue((String)"some server output left", (boolean)this.getServer().isClear(true));
        System.out.println("---/// TEST OK ///---");
    }

    public static void main(String[] args) {
        Test01_Server test = new Test01_Server();
        test.setUp();
        test.test();
        test.tearDown();
    }
}

