/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.navigation;

import cz.cuni.amis.pogamut.base.agent.navigation.AbstractPathExecutor;
import cz.cuni.amis.pogamut.base.agent.navigation.PathEventType;
import cz.cuni.amis.pogamut.base.agent.navigation.PathHandle;
import cz.cuni.amis.pogamut.base.agent.navigation.PathNotConstructable;
import cz.cuni.amis.pogamut.base.agent.navigation.steering.SteeringEventListener;
import cz.cuni.amis.pogamut.base.agent.navigation.steering.SteeringEventType;
import cz.cuni.amis.pogamut.base.agent.navigation.steering.SteeringExecutor;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.Collections;
import java.util.List;

public abstract class SimplePathExecutor<PATH_ELEMENT, AGENT_LOC>
extends AbstractPathExecutor<PATH_ELEMENT>
implements FlagListener<Integer>,
SteeringEventListener {
    PathHandle<PATH_ELEMENT> lastPath = null;
    private FlagListener<List<? extends PATH_ELEMENT>> listener = new FlagListener<List<? extends PATH_ELEMENT>>(){

        @Override
        public void flagChanged(List<? extends PATH_ELEMENT> path) {
            SimplePathExecutor.this.pathReceived(path);
        }
    };
    private List<? extends PATH_ELEMENT> actualPath = null;
    private int pathIndex = Integer.MIN_VALUE;
    private PATH_ELEMENT nextPathElement = null;
    private PATH_ELEMENT lastReachedPathElement = null;
    private List<SteeringExecutor> steeringExecutors = null;
    private SteeringExecutor rulingSteeringExecutor = null;

    @Override
    public void flagChanged(Integer changedValue) {
        this.evaluateSteeringExecutors();
    }

    protected void evaluateSteeringExecutors() {
        Collections.sort(this.steeringExecutors);
        this.rulingSteeringExecutor = this.steeringExecutors.iterator().next();
        this.rulingSteeringExecutor.initialize();
        this.rulingSteeringExecutor.execute();
    }

    protected String getExecutorsPrint() {
        String result = "Steering executors: \n";
        for (SteeringExecutor se : this.steeringExecutors) {
            result = String.valueOf(result) + " \t " + se.getClass().getSimpleName() + " " + se.getPriority().getFlag() + " \n";
        }
        return result;
    }

    @Override
    public void followPath(PathHandle<PATH_ELEMENT> path) {
        if (path == null) {
            this.fireEvent(PathEventType.BOT_STUCKED);
            return;
        }
        if (this.isMoving()) {
            this.stop();
        }
        if (this.lastPath != null) {
            this.lastPath.getPath().removeListener(this.listener);
        }
        this.lastPath = path;
        this.log("Going to " + path.getTargetDescription());
        if (!path.isFinalPath()) {
            path.getPath().addListener(this.listener);
        }
        try {
            List<PATH_ELEMENT> pathResult = path.getPath().getFlag();
            if (path != null) {
                this.pathReceived(pathResult);
            }
        }
        catch (PathNotConstructable ex) {
            this.fireEvent(PathEventType.TARGET_UNREACHABLE);
        }
        this.fireFollowPathCallSucessfull();
    }

    public PATH_ELEMENT getNextPathElement() {
        return this.getPathElement(this.pathIndex);
    }

    public PATH_ELEMENT getNextPathElement(int lookaheadIndex) {
        return this.getPathElement(this.pathIndex + lookaheadIndex);
    }

    public int getPathIndex() {
        return this.pathIndex;
    }

    public PATH_ELEMENT getPathElement(int index) {
        if (this.actualPath == null || index < 0 || index >= this.actualPath.size()) {
            return null;
        }
        return this.actualPath.get(index);
    }

    public void jumpPathIndex(int steps) {
        this.pathIndex += steps;
    }

    protected void pathReceived(List<? extends PATH_ELEMENT> path) {
        if (path != null) {
            int i = 0;
            while (i < path.size()) {
                if (path.get(i) == null) {
                    path.remove(i);
                    continue;
                }
                ++i;
            }
        }
        this.actualPath = path;
        if (path != null) {
            this.log("New path length: " + path.size() + "\n" + this.printPathElements(path));
        }
        if (path != null && !path.isEmpty()) {
            this.pathIndex = -1;
            this.moveToNext();
        } else {
            this.log("path null or empty");
            this.pathIndex = Integer.MIN_VALUE;
            this.fireEvent(PathEventType.PATH_BROKEN);
        }
    }

    @Override
    public void stop() {
        if (this.lastPath != null) {
            this.lastPath.getPath().removeListener(this.listener);
        }
        this.pathIndex = Integer.MIN_VALUE;
        this.actualPath = null;
        this.lastPath = null;
        this.nextPathElement = null;
    }

    protected String printPathElements(List<? extends PATH_ELEMENT> path) {
        String result = "";
        for (PATH_ELEMENT element : path) {
            result = String.valueOf(result) + this.pathElementString(element) + " | ";
        }
        return result;
    }

    protected String pathElementString(PATH_ELEMENT element) {
        if (element == null) {
            return "<null>";
        }
        if (element instanceof IWorldObject) {
            return ((IWorldObject)element).getId().getStringId();
        }
        return element.toString();
    }

    protected void moveToNext() {
        ++this.pathIndex;
        if (this.pathIndex < 0) {
            this.pathIndex = Integer.MIN_VALUE;
            return;
        }
        this.lastReachedPathElement = this.nextPathElement;
        this.nextPathElement = this.getNextPathElement();
        if (this.nextPathElement == null) {
            this.fireEvent(PathEventType.TARGET_REACHED);
        } else {
            this.fireEvent(PathEventType.PATH_ELEMENT_REACHED);
            this.evaluateSteeringExecutors();
        }
    }

    protected void moveToNextNext() {
        ++this.pathIndex;
        if (this.pathIndex < 0) {
            this.pathIndex = Integer.MIN_VALUE;
            return;
        }
        this.lastReachedPathElement = this.nextPathElement;
        this.nextPathElement = this.getNextPathElement();
        if (this.nextPathElement == null) {
            this.fireEvent(PathEventType.TARGET_REACHED);
        } else {
            this.log("Skipped one navpoint.");
            this.fireEvent(PathEventType.PATH_ELEMENT_REACHED);
            this.moveToNext();
        }
    }

    protected abstract AGENT_LOC getAgentLocation();

    protected void initSteeringExecutors() {
    }

    @Override
    public boolean isMoving() {
        return this.nextPathElement != null;
    }

    public void setSteeringExecutors(List<SteeringExecutor> steeringExecutors) {
        this.steeringExecutors = steeringExecutors;
        if (steeringExecutors != null && !steeringExecutors.isEmpty()) {
            this.initSteeringExecutorsListeners();
        }
    }

    protected List<SteeringExecutor> getSteeringExecutors() {
        return this.steeringExecutors;
    }

    protected void initSteeringExecutorsListeners() {
        for (SteeringExecutor executor : this.steeringExecutors) {
            executor.getPriority().addListener(this);
            executor.addListener(this);
        }
    }

    public PATH_ELEMENT getLastReachedPathElement() {
        return this.lastReachedPathElement;
    }

    protected void pathBroken() {
        this.fireEvent(PathEventType.PATH_BROKEN);
    }

    public void goStepsBack(int numberOfSteps) {
        if (this.pathIndex < 0) {
            return;
        }
        this.pathIndex -= numberOfSteps;
    }

    @Override
    public void steeringEventOccured(SteeringEventType steeringEvent) {
        this.log(steeringEvent.getMessage());
        if (steeringEvent.equals((Object)SteeringEventType.BOT_STUCKED) && this.rulingSteeringExecutor != null && this.rulingSteeringExecutor.equals(steeringEvent.getExecutor())) {
            this.fireEvent(PathEventType.BOT_STUCKED);
        }
    }
}

