/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.module;

import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.module.IAgentLogic;
import cz.cuni.amis.pogamut.base.agent.module.LogicModule;
import cz.cuni.amis.pogamut.base.component.bus.ComponentBus;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.component.stub.ComponentStub;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.logging.Level;
import junit.framework.Assert;
import org.junit.Test;

public class Test01_LogicModule {
    private Flag<Boolean> shutdown = new Flag<Boolean>(false);
    private boolean init = false;
    private Flag<Boolean> logic = new Flag<Boolean>(false);

    @Test
    public void test() {
        AgentId agentId = new AgentId("Test01_LogicModule");
        AgentLogger logger = new AgentLogger(agentId);
        logger.addDefaultConsoleHandler();
        logger.setLevel(Level.ALL);
        ComponentBus bus = new ComponentBus(logger);
        final ComponentStub starter = new ComponentStub(logger, bus);
        final LogCategory log = logger.getCategory("Logic");
        FlagListener<Boolean> logicListener = new FlagListener<Boolean>(){

            @Override
            public void flagChanged(Boolean changedValue) {
                if (changedValue.booleanValue()) {
                    starter.getController().manualStop("Logic sensed.");
                }
            }
        };
        this.logic.addListener(logicListener);
        IAgentLogic agentLogic = new IAgentLogic(){

            @Override
            public long getLogicInitializeTime() {
                return 0L;
            }

            @Override
            public long getLogicShutdownTime() {
                return 0L;
            }

            @Override
            public void logic() {
                log.info("Logic!!!");
                if (((Boolean)Test01_LogicModule.this.logic.getFlag()).booleanValue()) {
                    Assert.fail((String)"logic should be called only once");
                }
                Test01_LogicModule.this.logic.setFlag(true);
            }

            public void logicInitialize(LogicModule logicModule) {
                log.info("Logic initialize.");
                if (Test01_LogicModule.this.init) {
                    Assert.fail((String)"logicInitialize could not be called twice");
                }
            }

            @Override
            public void logicShutdown() {
                log.info("Logic shutdown.");
                if (((Boolean)Test01_LogicModule.this.shutdown.getFlag()).booleanValue()) {
                    Assert.fail((String)"logicShutdown() could not be called twice");
                }
                Test01_LogicModule.this.shutdown.setFlag(true);
            }
        };
        LogicModule<3> logicModule = new LogicModule<3>(new AbstractAgent(agentId, bus, logger){}, agentLogic, log, new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add(starter));
        int i = 0;
        while (i < 20) {
            System.out.println("---((( Iteration " + i + " / 19 )))---");
            this.init = false;
            this.logic.setFlag(false);
            this.shutdown.setFlag(false);
            starter.getController().manualStart("Starting the logic.");
            Boolean result = this.shutdown.waitFor(10000L, (T[])new Boolean[]{true});
            Assert.assertTrue((String)"logic should have terminated", (result != null && result != false ? 1 : 0) != 0);
            ++i;
        }
        System.out.println("---/// TEST OK ///---");
    }

    public static void main(String[] args) {
        Test01_LogicModule test = new Test01_LogicModule();
        test.test();
    }
}

