/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.leaktest;

import cz.cuni.amis.pogamut.base.agent.IAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.factory.INativeAgentFactory;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.utils.StopWatch;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import org.junit.Assert;
import org.junit.Test;

public abstract class AbstractLeakTest {
    public abstract INativeAgentFactory getFactory();

    public abstract ImmutableFlag<Integer> getInstances();

    private void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new PogamutInterruptedException(e, (Object)this);
        }
    }

    @Test
    public void test() {
        INativeAgentFactory factory = this.getFactory();
        StopWatch watch = new StopWatch();
        int i = 0;
        while (i < 10) {
            IAgent agent = factory.newAgent(new AgentId("TestAgent" + (i + 1)));
            System.out.println("/In test/ Agent started.");
            agent.start();
            this.sleep(10L);
            agent.pause();
            System.out.println("/In test/ " + this.getClass().getSimpleName() + "'s instances = " + this.getInstances().getFlag());
            Assert.assertTrue((String)(String.valueOf(this.getClass().getSimpleName()) + "'s instances must be > 0"), (this.getInstances().getFlag() > 0 ? 1 : 0) != 0);
            this.sleep(10L);
            agent.resume();
            this.sleep(10L);
            agent.stop();
            System.out.println("/In test/ Agent stopped.");
            this.sleep(10L);
            ++i;
        }
        System.out.println("Agents finished in " + watch.stopStr() + ".");
        factory = null;
        try {
            i = 0;
            while (i < 30) {
                System.gc();
                Integer value = this.getInstances().waitFor(1000L, (T[])new Integer[]{0});
                if (value != null && value == 0) {
                    System.out.println("All instances of " + this.getClass().getSimpleName() + " has been gc()ed, " + this.getClass().getSimpleName() + "'s instances = " + this.getInstances().getFlag() + ".");
                    System.out.println("---/// TEST OK ///---");
                    return;
                }
                System.out.println("/" + (i + 1) + " sec" + (i != 0 ? "s" : "") + "/ " + this.getClass().getSimpleName() + "'s instances = " + this.getInstances().getFlag());
                ++i;
            }
        }
        finally {
            Pogamut.getPlatform().close();
        }
        String str = "Not all " + this.getClass().getSimpleName() + " instances were gc()ed in 30secs after the test ended, " + this.getClass().getSimpleName() + "'s instances = " + this.getInstances().getFlag() + ".";
        System.out.println(str);
        Assert.fail((String)str);
    }
}

