/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.base.agent.impl;

import cz.cuni.amis.pogamut.base.agent.MockAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.module.MockModule;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateUp;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateFailed;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateInstantiated;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStatePaused;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateRunning;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateStopped;
import cz.cuni.amis.pogamut.base.agent.state.level3.IAgentStateResumed;
import cz.cuni.amis.pogamut.base.agent.state.level3.IAgentStateStarted;
import cz.cuni.amis.pogamut.base.component.bus.ComponentBus;
import cz.cuni.amis.pogamut.base.component.bus.event.impl.FatalErrorEvent;
import cz.cuni.amis.pogamut.base.component.controller.ComponentState;
import cz.cuni.amis.pogamut.base.component.stub.ComponentStub;
import cz.cuni.amis.pogamut.base.utils.logging.AgentLogger;
import java.util.logging.Level;
import junit.framework.Assert;
import org.junit.Test;

public class Test04_AbstractAgent {
    @Test
    public void test() {
        AgentId agentId = new AgentId("Test");
        AgentLogger logger = new AgentLogger(agentId);
        logger.setLevel(Level.ALL);
        logger.addDefaultConsoleHandler();
        ComponentBus bus = new ComponentBus(logger);
        MockAgent agent = new MockAgent(agentId, bus, logger);
        MockModule module = new MockModule(agent);
        ComponentStub stub = new ComponentStub(logger, bus);
        Assert.assertTrue((String)"agent not in down-state", (boolean)agent.inState(IAgentStateDown.class));
        Assert.assertTrue((String)"agent not in instantiated-state", (boolean)agent.inState(IAgentStateInstantiated.class));
        Assert.assertTrue((String)"module not in instantiated-state", (module.getState().getFlag() == ComponentState.INSTANTIATED ? 1 : 0) != 0);
        int i = 0;
        while (i < 10) {
            agent.start();
            Assert.assertTrue((String)"agent not in up-state", (boolean)agent.inState(IAgentStateUp.class));
            Assert.assertTrue((String)"agent not in started-state", (boolean)agent.inState(IAgentStateStarted.class));
            Assert.assertTrue((String)"agent not in running-state", (boolean)agent.inState(IAgentStateRunning.class));
            Assert.assertTrue((String)"module not in running-state", (module.getState().getFlag() == ComponentState.RUNNING ? 1 : 0) != 0);
            bus.event(new FatalErrorEvent<ComponentStub>(stub, "failure"));
            Assert.assertTrue((String)"agent not in down-state", (boolean)agent.inState(IAgentStateDown.class));
            Assert.assertTrue((String)"agent not in stopped-state", (boolean)agent.inState(IAgentStateFailed.class));
            Assert.assertTrue((String)"module not in stopped-state", (module.getState().getFlag() == ComponentState.KILLED ? 1 : 0) != 0);
            ++i;
        }
        agent.start();
        Assert.assertTrue((String)"agent not in up-state", (boolean)agent.inState(IAgentStateUp.class));
        Assert.assertTrue((String)"agent not in started-state", (boolean)agent.inState(IAgentStateStarted.class));
        Assert.assertTrue((String)"agent not in running-state", (boolean)agent.inState(IAgentStateRunning.class));
        Assert.assertTrue((String)"module not in running-state", (module.getState().getFlag() == ComponentState.RUNNING ? 1 : 0) != 0);
        i = 0;
        while (i < 10) {
            agent.pause();
            Assert.assertTrue((String)"agent not in up-state", (boolean)agent.inState(IAgentStateUp.class));
            Assert.assertTrue((String)"agent not in paused-state", (boolean)agent.inState(IAgentStatePaused.class));
            Assert.assertTrue((String)"module not in paused-state", (module.getState().getFlag() == ComponentState.PAUSED ? 1 : 0) != 0);
            agent.resume();
            Assert.assertTrue((String)"agent not in up-state", (boolean)agent.inState(IAgentStateUp.class));
            Assert.assertTrue((String)"agent not in resumed-state", (boolean)agent.inState(IAgentStateResumed.class));
            Assert.assertTrue((String)"module not in running-state", (module.getState().getFlag() == ComponentState.RUNNING ? 1 : 0) != 0);
            ++i;
        }
        i = 0;
        while (i < 10) {
            bus.event(new FatalErrorEvent<ComponentStub>(stub, "failure"));
            Assert.assertTrue((String)"agent not in down-state", (boolean)agent.inState(IAgentStateDown.class));
            Assert.assertTrue((String)"agent not in stopped-state", (boolean)agent.inState(IAgentStateFailed.class));
            Assert.assertTrue((String)"module not in killed-state", (module.getState().getFlag() == ComponentState.KILLED ? 1 : 0) != 0);
            agent.start();
            Assert.assertTrue((String)"agent not in up-state", (boolean)agent.inState(IAgentStateUp.class));
            Assert.assertTrue((String)"agent not in started-state", (boolean)agent.inState(IAgentStateStarted.class));
            Assert.assertTrue((String)"agent not in running-state", (boolean)agent.inState(IAgentStateRunning.class));
            Assert.assertTrue((String)"module not in running-state", (module.getState().getFlag() == ComponentState.RUNNING ? 1 : 0) != 0);
            ++i;
        }
        i = 0;
        while (i < 10) {
            agent.pause();
            Assert.assertTrue((String)"agent not in up-state", (boolean)agent.inState(IAgentStateUp.class));
            Assert.assertTrue((String)"agent not in paused-state", (boolean)agent.inState(IAgentStatePaused.class));
            Assert.assertTrue((String)"module not in paused-state", (module.getState().getFlag() == ComponentState.PAUSED ? 1 : 0) != 0);
            agent.resume();
            Assert.assertTrue((String)"agent not in up-state", (boolean)agent.inState(IAgentStateUp.class));
            Assert.assertTrue((String)"agent not in resumed-state", (boolean)agent.inState(IAgentStateResumed.class));
            Assert.assertTrue((String)"module not in running-state", (module.getState().getFlag() == ComponentState.RUNNING ? 1 : 0) != 0);
            bus.event(new FatalErrorEvent<ComponentStub>(stub, "failure"));
            Assert.assertTrue((String)"agent not in down-state", (boolean)agent.inState(IAgentStateDown.class));
            Assert.assertTrue((String)"agent not in stopped-state", (boolean)agent.inState(IAgentStateFailed.class));
            Assert.assertTrue((String)"module not in killed-state", (module.getState().getFlag() == ComponentState.KILLED ? 1 : 0) != 0);
            agent.start();
            Assert.assertTrue((String)"agent not in up-state", (boolean)agent.inState(IAgentStateUp.class));
            Assert.assertTrue((String)"agent not in started-state", (boolean)agent.inState(IAgentStateStarted.class));
            Assert.assertTrue((String)"agent not in running-state", (boolean)agent.inState(IAgentStateRunning.class));
            Assert.assertTrue((String)"module not in running-state", (module.getState().getFlag() == ComponentState.RUNNING ? 1 : 0) != 0);
            ++i;
        }
        agent.stop();
        Assert.assertTrue((String)"agent not in down-state", (boolean)agent.inState(IAgentStateDown.class));
        Assert.assertTrue((String)"agent not in stopped-state", (boolean)agent.inState(IAgentStateStopped.class));
        Assert.assertTrue((String)"module not in stopped-state", (module.getState().getFlag() == ComponentState.STOPPED ? 1 : 0) != 0);
        System.out.println("---/// TEST OK ///---");
    }
}

