/*
 * Decompiled with CFR 0.152.
 */
package civilian;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.navigation.PathEventType;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorListener;
import cz.cuni.amis.pogamut.base.agent.navigation.PathHandle;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UTPathExecutor;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallPathPlanner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetectors.StupidStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Respawn;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GlobalChat;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.factory.direct.remoteagent.UT2004ServerFactory;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.pogamut.ut2004.utils.MultipleUT2004BotRunner;
import cz.cuni.amis.utils.Tuple2;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Civilian
extends UT2004BotModuleController {
    public static final double COMMAND_HISTORY_TIMEOUT = 2.0;
    public static final int MAX_COMMAND_HISTORY_LENGTH = 6;
    public static final int UPDATE_PATH_TO_PLAYER_AFTER_N_NAVPOINTS_REACHED = 2;
    private static final double FOLLOW_DIRECT_MOVE_DISTANCE = 250.0;
    public static final double BUBBLE_FADEOUT = 2.0;
    public static final double MOVEMENT_SPEED = 0.7;
    private static final double TALKING_DISTANCE = 1000.0;
    public static final String CIVILIAN_NAME = "Civilian";
    public static final String QUESTION_SEE = "Can you see me?";
    public static final String ANSWER_SEE_YES = "Yes.";
    public static final String ANSWER_SEE_NO = "No.";
    public static final String COMMAND_STOP = "Stop!";
    public static final String ANSWER_STOP_OK = "Okey!";
    public static final String COMMAND_TURN = "Turn!";
    public static final String ANSWER_TURN_OK = "Turning!";
    public static final String COMMAND_FOLLOW_ME = "Follow me!";
    public static final String ANSWER_FOLLOW_ME_OK = "I'm right behind you!";
    public static final String ANSWER_FOLLOW_ME_CANT_SEE_YOU = "I can't see you, sorry.";
    public static final String ANSWER_ANGRY = "Hey, don't boss me around!";
    public static final String SAY_CANT_SEE_YOU = "I've lost you!";
    public static final String ANSWER_DONT_UNDERSTAND = "I don't understand you.";
    private static final String AT_FACTORY_MSG = "Cool I'm at factory!";
    private List<Tuple2<Double, String>> commandsHistory = new ArrayList<Tuple2<Double, String>>();
    private List<String> chat = new ArrayList<String>();
    private List<NavPoint> navPointsFarFromFactory = new ArrayList<NavPoint>();
    private NavPoint factoryNavPoint = null;
    private double behaviorTimeOut = 0.0;
    Location runningToLocation = null;
    boolean moving = false;
    Player runningToPlayer = null;
    NavPoint runningToNavPoint = null;
    int updatePathToPlayerCounter = 3;
    State state = State.WANDERING;
    static IUT2004Server server;

    protected void initializePathFinding(UT2004Bot bot) {
        this.pathPlanner = new FloydWarshallPathPlanner(bot);
        this.pathExecutor = new UTPathExecutor(bot);
    }

    @EventListener(eventClass=GlobalChat.class)
    public void eventGlobalChat(GlobalChat event) {
        Player sender = null;
        for (Player plr : server.getPlayers()) {
            if (!plr.getId().equals(event.getId())) continue;
            sender = plr;
            break;
        }
        if (sender == null) {
            this.user.severe("Can't locate sender under id: " + event.getId().getStringId());
            return;
        }
        if (sender.getLocation().getDistance(this.info.getLocation()) >= 1000.0) {
            this.body.getCommunication().sendGlobalBubbleMessage(ANSWER_DONT_UNDERSTAND, 2.0);
            return;
        }
        this.chat.add(event.getText());
        this.commandsHistory.add(new Tuple2<Double, String>(2.0, event.getText()));
    }

    @Override
    public void botInitialized(GameInfo gameInfo, ConfigChange config, InitedMessage init) {
        this.pathExecutor.addStuckDetector(new StupidStuckDetector(this.getWorldView(), 6.0));
        this.pathExecutor.addPathListener(new PathExecutorListener(){

            @Override
            public void onEvent(PathEventType eventType) {
                switch (eventType) {
                    case TARGET_REACHED: {
                        Civilian.this.pathEventTargetReached();
                        break;
                    }
                    case PATH_ELEMENT_REACHED: {
                        Civilian.this.pathEventNavPointReached();
                        break;
                    }
                    case BOT_STUCKED: {
                        Civilian.this.pathEventBotStuck();
                    }
                }
            }
        });
        this.factoryNavPoint = DistanceUtils.getNearest(this.world.getAll(NavPoint.class).values(), this.world.getSingle(GameInfo.class).getFactoryLocation());
        for (NavPoint np : this.world.getAll(NavPoint.class).values()) {
            if (!(np.getLocation().getDistance(this.factoryNavPoint.getLocation()) > 1500.0)) continue;
            this.navPointsFarFromFactory.add(np);
        }
        this.config.setSpeedMultiplier(0.7);
        this.switchState(State.WANDERING);
        this.config.setManualSpawn(true);
    }

    public void respawn() {
        this.getAct().act(new Respawn().setStartLocation(new Location(-2150.0 + this.random.nextDouble() * 400.0 - 200.0, -7330.0 + this.random.nextDouble() * 400.0 - 200.0, -4556.0)));
    }

    @Override
    public Initialize getInitializeCommand() {
        return new Initialize().setName(CIVILIAN_NAME);
    }

    public NavPoint pickNavPointFarFromFactory() {
        return MyCollections.getRandom(this.navPointsFarFromFactory);
    }

    public void switchState(State newState) {
        if (newState == this.state) {
            return;
        }
        this.state = newState;
        this.behaviorTimeOut = this.state == State.WANDERING ? 0.0 : this.random.nextDouble() * 15.0 + 10.0;
        this.config.setName("Civilian [" + (Object)((Object)this.state) + "]");
        this.user.info("State switched to: " + (Object)((Object)newState));
    }

    public boolean isMoving() {
        return this.moving;
    }

    public boolean canSeePlayer() {
        return this.players.getNearestVisiblePlayer() != null;
    }

    public boolean atFactory() {
        return this.factoryNavPoint.getLocation().getDistance(this.info.getLocation()) < 300.0;
    }

    public double getDistanceToTarget() {
        if (this.runningToLocation == null) {
            return Double.MAX_VALUE;
        }
        return this.runningToLocation.getDistance(this.info.getLocation());
    }

    public void stopMovement() {
        this.pathExecutor.stop();
        this.move.stopMovement();
        this.moving = false;
        this.runningToLocation = null;
        this.runningToPlayer = null;
        this.runningToNavPoint = null;
    }

    public void runToNavPoint(NavPoint navPoint) {
        if (this.runningToNavPoint == navPoint) {
            return;
        }
        this.user.info("Running to navpoint: " + navPoint.getId().getStringId());
        this.moving = true;
        this.runningToPlayer = null;
        this.runningToNavPoint = navPoint;
        this.runningToLocation = navPoint.getLocation();
        this.pathExecutor.followPath(this.pathPlanner.computePath(navPoint));
    }

    public void runToPlayer(Player player) {
        if (this.runningToPlayer == player) {
            return;
        }
        this.user.info("Running to player: " + player.getId().getStringId());
        this.moving = true;
        this.runningToPlayer = player;
        this.runningToNavPoint = null;
        this.runningToLocation = player.getLocation();
        this.updatePathToPlayerCounter = 2;
        this.pathExecutor.followPath(this.pathPlanner.computePath(player));
    }

    public void pathEventBotStuck() {
        this.stopMovement();
    }

    public void pathEventNavPointReached() {
        if (this.runningToPlayer != null) {
            --this.updatePathToPlayerCounter;
            if (this.updatePathToPlayerCounter <= 0 && this.runningToPlayer.isVisible()) {
                this.runToPlayer(this.runningToPlayer);
            }
        }
    }

    public void pathEventTargetReached() {
        this.stopMovement();
    }

    @Override
    public void logic() {
        this.user.severe("---=== LOGIC ===---");
        this.user.info("Adrenalines:        " + this.info.getAdrenaline());
        this.user.info("Weapon:             " + this.weaponry.getCurrentWeapon());
        this.user.info("Ammo:               " + this.weaponry.getCurrentAmmo());
        this.user.info("Can see player:     " + this.players.canSeePlayers());
        if (this.isMoving()) {
            this.user.info("Path distance:      " + this.getDistanceToTarget());
        }
        this.user.info("Factory distance:   " + this.factoryNavPoint.getLocation().getDistance(this.info.getLocation()));
        this.user.info("State:              " + (Object)((Object)this.state));
        this.user.info("--- ACTION SELECTION---");
        if (this.atFactory()) {
            this.switchState(State.FINAL);
        }
        if (this.state != State.FOLLOWING && this.state != State.FINAL && this.state != State.STANDING_STILL && this.factoryNavPoint.getLocation().getDistance(this.info.getLocation()) < 1500.0) {
            this.stopMovement();
            while (true) {
                List path;
                PathHandle handle;
                if ((handle = this.pathPlanner.computePath(this.pickNavPointFarFromFactory())) == null || (path = handle.getPath().getFlag()) == null) {
                    continue;
                }
                boolean ok = true;
                for (ILocated loc : path) {
                    if (!(loc.getLocation().getDistance(this.factoryNavPoint.getLocation()) < 1000.0)) continue;
                    ok = false;
                    break;
                }
                if (ok) break;
            }
        }
        if (this.state != State.FINAL) {
            this.pruneCommandHistory();
            if (this.commandsHistory.size() > 6) {
                this.body.getCommunication().sendGlobalBubbleMessage(ANSWER_ANGRY, 2.0);
                this.switchState(State.ANGRY);
            } else {
                for (String text : this.chat) {
                    this.handleChat(text);
                }
            }
            switch (this.state) {
                case ANGRY: {
                    this.angry();
                    break;
                }
                case WANDERING: {
                    this.wandering();
                    break;
                }
                case STANDING_STILL: {
                    this.standingStill();
                    break;
                }
                case FOLLOWING: {
                    this.following();
                }
            }
        } else {
            this.finalState();
        }
        this.chat.clear();
    }

    private void pruneCommandHistory() {
        Iterator<Tuple2<Double, String>> iter = this.commandsHistory.iterator();
        while (iter.hasNext()) {
            Tuple2<Double, String> tuple = iter.next();
            tuple.setFirst(tuple.getFirst() - this.senses.getTimeDelta());
            if (!(tuple.getFirst() < 0.0)) continue;
            iter.remove();
        }
        this.user.info("Command history length: " + this.commandsHistory.size());
    }

    private void handleChat(String text) {
        if (text.equalsIgnoreCase(QUESTION_SEE)) {
            this.user.info("Answering ASK_SEE");
            if (this.players.canSeePlayers()) {
                this.body.getCommunication().sendGlobalBubbleMessage(ANSWER_SEE_YES, 2.0);
            } else {
                this.body.getCommunication().sendGlobalBubbleMessage(ANSWER_SEE_NO, 2.0);
            }
        } else if (text.equalsIgnoreCase(COMMAND_STOP)) {
            this.user.info("Answering COMMAND_STOP");
            this.body.getCommunication().sendGlobalBubbleMessage(ANSWER_STOP_OK, 2.0);
            this.stopMovement();
            this.switchState(State.STANDING_STILL);
        } else if (text.equalsIgnoreCase(COMMAND_TURN)) {
            this.user.info("Answering COMMAND_TURN");
            this.body.getCommunication().sendGlobalBubbleMessage(ANSWER_TURN_OK, 2.0);
            this.move.turnHorizontal(80);
            this.switchState(State.STANDING_STILL);
        } else if (text.equalsIgnoreCase(COMMAND_FOLLOW_ME)) {
            this.user.info("Answering COMMAND_FOLLOW_ME");
            if (this.canSeePlayer()) {
                this.body.getCommunication().sendGlobalBubbleMessage(ANSWER_FOLLOW_ME_OK, 2.0);
                this.stopMovement();
                this.switchState(State.FOLLOWING);
            } else {
                this.body.getCommunication().sendGlobalBubbleMessage(ANSWER_FOLLOW_ME_CANT_SEE_YOU, 2.0);
                this.stopMovement();
                this.switchState(State.STANDING_STILL);
            }
        } else {
            this.user.info("Answering DONT_UNDERSTAND");
            this.body.getCommunication().sendGlobalBubbleMessage(ANSWER_DONT_UNDERSTAND, 2.0);
        }
    }

    private void angry() {
        this.commandsHistory.clear();
        if (this.chat.size() > 0) {
            this.body.getCommunication().sendGlobalBubbleMessage(ANSWER_ANGRY, 2.0);
        }
        this.behaviorTimeOut -= this.senses.getTimeDelta().doubleValue();
        if (this.behaviorTimeOut < 0.0) {
            this.stopMovement();
            this.switchState(State.WANDERING);
            return;
        }
        if (this.isMoving()) {
            return;
        }
        this.runToNavPoint(this.pickNavPointFarFromFactory());
    }

    private void wandering() {
        if (this.isMoving()) {
            return;
        }
        this.runToNavPoint(this.pickNavPointFarFromFactory());
    }

    private void following() {
        this.behaviorTimeOut -= this.senses.getTimeDelta().doubleValue();
        if (this.behaviorTimeOut < 0.0) {
            this.stopMovement();
            this.switchState(State.WANDERING);
            return;
        }
        if (this.canSeePlayer()) {
            Player player = this.players.getNearestVisiblePlayer();
            if (player.getLocation().getDistance(this.info.getLocation()) < 250.0) {
                if (this.moving) {
                    this.stopMovement();
                }
                this.move.moveTo(player);
            } else {
                this.runToPlayer(this.players.getNearestVisiblePlayer());
            }
        } else {
            this.stopMovement();
        }
    }

    private void finalState() {
        this.stopMovement();
        this.body.getCommunication().sendGlobalBubbleMessage(AT_FACTORY_MSG, 2.0);
    }

    private void standingStill() {
        this.behaviorTimeOut -= this.senses.getTimeDelta().doubleValue();
        if (this.behaviorTimeOut < 0.0) {
            this.stopMovement();
            this.switchState(State.WANDERING);
            return;
        }
    }

    @Override
    public void botKilled(BotKilled event) {
        this.stopMovement();
        this.switchState(State.WANDERING);
        this.respawn();
    }

    public static void main(String[] args) throws PogamutException {
        UT2004ServerFactory factory = new UT2004ServerFactory();
        server = factory.newAgent((IAgentId)new AgentId("server"), new SocketConnectionAddress("localhost", 3001));
        server.start();
        new MultipleUT2004BotRunner(1, Civilian.class, CIVILIAN_NAME).startAgent();
    }

    private static enum State {
        ANGRY,
        WANDERING,
        STANDING_STILL,
        FOLLOWING,
        FINAL;

    }
}

