/*
 * Decompiled with CFR 0.152.
 */
package guide;

import cz.cuni.amis.pogamut.base.agent.navigation.PathEventType;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectClassEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.event.WorldObjectAppearedEvent;
import cz.cuni.amis.pogamut.base3d.worldview.object.event.WorldObjectDisappearedEvent;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetectors.StupidStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GlobalChat;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.utils.SingleUT2004BotRunner;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.ArrayList;
import java.util.List;

public class Guide
extends UT2004BotModuleController {
    public static final String QUESTION_SEE = "Can you see me?";
    public static final String ANSWER_SEE_YES = "Yes.";
    public static final String ANSWER_SEE_NO = "No.";
    public static final String COMMAND_STOP = "Stop!";
    public static final String ANSWER_STOP_OK = "Okey!";
    public static final String COMMAND_TURN = "Turn!";
    public static final String ANSWER_TURN_OK = "Turning!";
    public static final String COMMAND_FOLLOW_ME = "Follow me!";
    public static final String ANSWER_FOLLOW_ME_OK = "I'm right behind you!";
    public static final String ANSWER_FOLLOW_ME_CANT_SEE_YOU = "I can't see you, sorry.";
    public static final String ANSWER_ANGRY = "Hey, don't boss me around!";
    public static final String SAY_CANT_SEE_YOU = "I've lost you!";
    public static final String ANSWER_DONT_UNDERSTAND = "I don't understand you.";
    public static final String AT_FACTORY_MSG = "Cool I'm at factory!";
    public static final double BUBBLE_FADEOUT = 2.0;
    public static final int UPDATE_PATH_TO_PLAYER_AFTER_N_NAVPOINTS_REACHED = 3;
    public static final double TALKING_DISTANCE = 1000.0;
    TabooSet<NavPoint> seenNavs;
    List<String> chat = new ArrayList<String>();
    Location previousCivilianLocation = null;
    boolean civilianIsMoving = false;
    boolean canSeeCivilian = false;
    int updatePathToPlayerCounter = 3;
    Location runningToLocation = null;
    boolean moving = false;
    Player runningToPlayer = null;
    NavPoint runningToNavPoint = null;

    @Override
    public void prepareBot(UT2004Bot bot) {
        this.seenNavs = new TabooSet(bot);
        this.pathExecutor.addStuckDetector(new StupidStuckDetector(this.world, 3.0));
        this.pathExecutor.addPathListener(new PathExecutorListener(){

            @Override
            public void onEvent(PathEventType eventType) {
                switch (eventType) {
                    case BOT_STUCKED: {
                        Guide.this.pathEventBotStuck();
                        break;
                    }
                    case PATH_ELEMENT_REACHED: {
                        Guide.this.pathEventNavPointReached();
                        break;
                    }
                    case TARGET_REACHED: {
                        Guide.this.pathEventTargetReached();
                    }
                }
            }
        });
    }

    @Override
    public Initialize getInitializeCommand() {
        return new Initialize().setName("Guide");
    }

    @Override
    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
    }

    @Override
    public void botSpawned(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init, Self self) {
    }

    @EventListener(eventClass=GlobalChat.class)
    public void eventGlobalChat(GlobalChat event) {
        this.chat.add(event.getText());
    }

    @ObjectClassEventListener(eventClass=WorldObjectAppearedEvent.class, objectClass=NavPoint.class)
    public void eventNavPointAppeared(WorldObjectAppearedEvent<NavPoint> event) {
        this.seenNavs.add((NavPoint)event.getObject());
    }

    @ObjectClassEventListener(eventClass=WorldObjectAppearedEvent.class, objectClass=Player.class)
    public void eventPlayerAppeared(WorldObjectAppearedEvent<Player> event) {
        this.canSeeCivilian = true;
        this.previousCivilianLocation = null;
    }

    @ObjectClassEventListener(eventClass=WorldObjectUpdatedEvent.class, objectClass=Player.class)
    public void eventPlayerUpdated(WorldObjectUpdatedEvent<Player> event) {
        if (this.previousCivilianLocation != null) {
            this.civilianIsMoving = this.previousCivilianLocation.getDistance(((Player)event.getObject()).getLocation()) > 20.0;
        }
        this.previousCivilianLocation = ((Player)event.getObject()).getLocation();
    }

    @ObjectClassEventListener(eventClass=WorldObjectDisappearedEvent.class, objectClass=Player.class)
    public void eventPlayerDisappeared(WorldObjectDisappearedEvent<Player> event) {
        this.canSeeCivilian = false;
        this.civilianIsMoving = false;
    }

    public boolean knowNavPointToExplore() {
        return this.getNavPointToExplore() != null;
    }

    public boolean canSeePlayer() {
        return this.getNearestVisiblePlayer() != null;
    }

    public NavPoint getRandomNavPoint() {
        return MyCollections.getRandom(this.world.getAll(NavPoint.class).values());
    }

    public NavPoint getNearestNavPoint() {
        return this.info.getNearestNavPoint();
    }

    public NavPoint getNavPointToExplore() {
        NavPoint nav = DistanceUtils.getNearest(this.seenNavs.filter(this.world.getAll(NavPoint.class).values()), this.info.getLocation());
        if (nav != null) {
            this.user.info("navpoint to explore: " + nav.getId().getStringId());
            return nav;
        }
        this.user.info("navpoint to explore: NULL");
        return null;
    }

    public NavPoint getNearestVisibleNavPoint() {
        return this.info.getNearestVisibleNavPoint();
    }

    public Player getNearestVisiblePlayer() {
        return this.players.getNearestVisiblePlayer();
    }

    public double getDistanceToNearestVisiblePlayer() {
        Player player = this.getNearestVisiblePlayer();
        return player == null ? Double.MAX_VALUE : player.getLocation().getDistance(this.info.getLocation());
    }

    public boolean isPlayerInTalkingDistance() {
        return this.getDistanceToNearestVisiblePlayer() < 1000.0;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public boolean isRunningToPlayer() {
        return this.runningToPlayer != null;
    }

    public boolean isRunningToNavPoint() {
        return this.runningToNavPoint != null;
    }

    public double getDistanceToTarget() {
        if (this.runningToLocation == null) {
            return Double.MAX_VALUE;
        }
        return this.runningToLocation.getDistance(this.info.getLocation());
    }

    public boolean canSeeCivilian() {
        return this.canSeeCivilian;
    }

    public boolean isCivilianMoving() {
        return this.civilianIsMoving;
    }

    public void pathEventBotStuck() {
        this.stopMovement();
    }

    public void pathEventNavPointReached() {
        if (this.runningToPlayer != null) {
            --this.updatePathToPlayerCounter;
            if (this.updatePathToPlayerCounter <= 0 && this.runningToPlayer.isVisible()) {
                this.runToPlayer(this.runningToPlayer);
            }
        }
    }

    public void pathEventTargetReached() {
        this.stopMovement();
    }

    public void stopMovement() {
        this.pathExecutor.stop();
        this.move.stopMovement();
        this.moving = false;
        this.runningToLocation = null;
        this.runningToPlayer = null;
        this.runningToNavPoint = null;
    }

    public void runToNavPoint(NavPoint navPoint) {
        if (this.runningToNavPoint == navPoint) {
            return;
        }
        this.user.info("Running to navpoint: " + navPoint.getId().getStringId());
        this.moving = true;
        this.runningToPlayer = null;
        this.runningToNavPoint = navPoint;
        this.runningToLocation = navPoint.getLocation();
        this.pathExecutor.followPath(this.pathPlanner.computePath(navPoint));
    }

    public void runToPlayer(Player player) {
        if (this.runningToPlayer == player) {
            return;
        }
        this.user.info("Running to player: " + player.getId().getStringId());
        this.moving = true;
        this.runningToPlayer = player;
        this.runningToNavPoint = null;
        this.runningToLocation = player.getLocation();
        this.updatePathToPlayerCounter = 3;
        this.pathExecutor.followPath(this.pathPlanner.computePath(player));
    }

    public void say(String text) {
        this.body.getCommunication().sendGlobalBubbleMessage(text, 2.0);
    }

    public void commandCivilianStop() {
        this.user.info("Commanding civilian to stop.");
        this.say(COMMAND_STOP);
    }

    public void commandCivilianTurn() {
        this.user.info("Commanding civilian to turn.");
        this.say(COMMAND_TURN);
    }

    public void commandCivilianFollowMe() {
        this.user.info("Commanding civilian to follow the guide.");
        this.say(COMMAND_FOLLOW_ME);
    }

    public void questionCivilianCanSee() {
        this.user.info("Asking the civilian whether he can see the guide.");
        this.say(QUESTION_SEE);
    }

    @Override
    public void botKilled(BotKilled event) {
        this.stopMovement();
    }

    public void handleChat() {
        for (String text : this.chat) {
            if (text.equalsIgnoreCase(ANSWER_ANGRY)) {
                this.user.info("Civilian is angry.");
                this.answerAngry();
                continue;
            }
            if (text.equalsIgnoreCase(ANSWER_DONT_UNDERSTAND)) {
                this.user.info("Civilian don't understand.");
                this.answerDontUnderstand();
                continue;
            }
            if (text.equalsIgnoreCase(ANSWER_FOLLOW_ME_CANT_SEE_YOU)) {
                this.user.info("Civilian can't follow the guide, he does not see him.");
                this.answerCantFollowCantSee();
                continue;
            }
            if (text.equalsIgnoreCase(ANSWER_FOLLOW_ME_OK)) {
                this.user.info("Civilian starts to follow the guide.");
                this.answerFollowingOk();
                continue;
            }
            if (text.equalsIgnoreCase(ANSWER_SEE_NO)) {
                this.user.info("Civilian can't see the guide.");
                this.answerCantSee();
                continue;
            }
            if (text.equalsIgnoreCase(ANSWER_SEE_YES)) {
                this.user.info("Civilian can see the guide.");
                this.answerCanSee();
                continue;
            }
            if (text.equalsIgnoreCase(ANSWER_STOP_OK)) {
                this.user.info("Civilian stopped.");
                this.answerStopped();
                continue;
            }
            if (text.equalsIgnoreCase(ANSWER_TURN_OK)) {
                this.user.info("Civilian turning.");
                this.answerTurning();
                continue;
            }
            this.user.severe("Civilian responded with unknown message.");
        }
    }

    public void answerAngry() {
        this.exampleAngry();
    }

    public void answerDontUnderstand() {
        this.exampleDontUnderstand();
    }

    public void answerCantFollowCantSee() {
        this.exampleCantFollowCantSee();
    }

    public void answerFollowingOk() {
        this.exampleFollowingOk();
    }

    public void answerCantSee() {
        this.exampleCantSee();
    }

    public void answerCanSee() {
        this.exampleCanSee();
    }

    public void answerStopped() {
        this.exampleStopped();
    }

    public void answerTurning() {
        this.exampleTurning();
    }

    @Override
    public void logic() throws PogamutException {
        this.user.severe("---=== LOGIC ===---");
        this.user.info("Adrenalines:         " + this.info.getAdrenaline());
        this.user.info("Weapon:              " + this.weaponry.getCurrentWeapon());
        this.user.info("Ammo:                " + this.weaponry.getCurrentAmmo());
        this.user.info("Can see player:      " + this.canSeePlayer());
        if (this.isRunningToPlayer()) {
            this.user.info("Running to player:   " + this.runningToPlayer.getId().getStringId());
        }
        if (this.isRunningToNavPoint()) {
            this.user.info("Running to navpoint: " + this.runningToNavPoint.getId().getStringId());
        }
        if (this.isMoving()) {
            this.user.info("Distance:            " + this.getDistanceToTarget());
        }
        this.user.info("--- ACTION SELECTION---");
        this.handleChat();
        this.exampleImplementation();
    }

    private void exampleImplementation() {
    }

    private void exampleAngry() {
    }

    private void exampleDontUnderstand() {
    }

    private void exampleCantFollowCantSee() {
    }

    private void exampleFollowingOk() {
    }

    private void exampleCantSee() {
    }

    private void exampleTurning() {
    }

    private void exampleCanSee() {
    }

    private void exampleStopped() {
    }

    public static void main(String[] args) throws PogamutException {
        new SingleUT2004BotRunner(Guide.class, "EmoDoc").startAgent();
    }
}

