/*
 * Decompiled with CFR 0.152.
 */
package explorerbot;

import cz.cuni.amis.pogamut.base.agent.navigation.PathEventType;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorListener;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.stuckdetectors.StupidStuckDetector;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.utils.SingleUT2004BotRunner;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutIOException;
import cz.cuni.amis.utils.maps.HashMapMap;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class ExplorerBot
extends UT2004BotModuleController {
    private HashMapMap<NavPoint, NavPoint, Boolean> navs = new HashMapMap();
    private int failures = 0;
    private int failuresPathBroken = 0;
    List<NavPoint> navs1 = new ArrayList<NavPoint>();
    int navs1Index = 0;
    int navs2Index = 1;
    boolean finished = false;
    List<NavPoint> pathNavs = new ArrayList<NavPoint>();
    int stuckCounter = 0;
    int pathBroken = 0;
    static int BOT_NUMBER = 0;

    @Override
    public void botInitialized(GameInfo gameInfo, ConfigChange config, InitedMessage init) {
        this.bot.getLogger().getCategory("UTPathExecutor").setLevel(Level.ALL);
        this.pathExecutor.addStuckDetector(new StupidStuckDetector(this.getWorldView(), 6.0));
        this.pathExecutor.addPathListener(new PathExecutorListener(){

            @Override
            public void onEvent(PathEventType eventType) {
                switch (eventType) {
                    case TARGET_REACHED: {
                        ExplorerBot.this.targetReached();
                        break;
                    }
                    case PATH_ELEMENT_REACHED: {
                        ExplorerBot.this.nextNavPointReached();
                        break;
                    }
                    case BOT_STUCKED: {
                        ExplorerBot.this.botStucked();
                        break;
                    }
                    case PATH_BROKEN: {
                        ExplorerBot.this.pathBroken();
                    }
                }
            }
        });
        this.navs1 = MyCollections.asList(this.world.getAll(NavPoint.class).values());
    }

    @Override
    public Initialize getInitializeCommand() {
        return new Initialize().setName("ExploreBot - The Harmless");
    }

    private void increaseNavIndexTo() {
        ++this.navs2Index;
        this.pathBroken = 0;
        if (this.navs2Index == this.navs1Index) {
            ++this.navs2Index;
        }
        if (this.navs2Index >= this.navs1.size()) {
            this.increaseNavIndexFrom();
            this.navs2Index = 0;
        }
        if (this.finished) {
            return;
        }
        if (this.navs.get(this.from()).containsKey(this.to())) {
            this.user.info("Known navpoint combination, skipping...");
            this.increaseNavIndexTo();
        }
    }

    private void increaseNavIndexFrom() {
        ++this.navs1Index;
        if (this.navs1Index >= this.navs1.size()) {
            this.finished = true;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    ExplorerBot.this.bot.stop();
                }
            }).start();
        }
    }

    private NavPoint from() {
        return this.navs1.get(this.navs1Index);
    }

    private NavPoint to() {
        return this.navs1.get(this.navs2Index);
    }

    @Override
    public void botSpawned(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init, Self self) {
        if (this.navs1.size() == 0) {
            this.bot.kill();
            return;
        }
        this.respawn();
    }

    @Override
    public void logic() {
        if (this.finished) {
            this.user.warning("FINISHED!");
            return;
        }
        if (!this.pathExecutor.isMoving()) {
            NavPoint start = this.info.getNearestNavPoint();
            if (start != this.from()) {
                this.user.severe("From != Current -> respawning.");
                this.respawn();
                return;
            }
            this.user.info("STATUS:   " + (this.navs1Index * this.navs1.size() + this.navs2Index) + " / " + (this.navs1.size() * this.navs1.size() - 1));
            this.user.info("FAILURES: " + this.failures);
            this.user.info("FAILURES (PATH BROKEN): " + this.failuresPathBroken);
            this.user.info("Testing:  " + this.from().getId().getStringId() + " -> " + this.to().getId().getStringId());
            this.stuckCounter = 0;
            this.pathNavs.clear();
            this.pathExecutor.followPath(this.pathPlanner.computePath(this.to()));
        }
    }

    private void respawn() {
        this.user.warning("RESPAWN!!!");
        this.body.getAction().respawn(this.from());
    }

    protected void botStucked() {
        ++this.stuckCounter;
        this.user.info(String.valueOf(this.from().getId().getStringId()) + " -> " + this.to().getId().getStringId() + " stuck " + this.stuckCounter + "x");
        if (this.stuckCounter >= 2) {
            this.user.warning("FAILED: " + this.from().getId().getStringId() + " -> " + this.to().getId().getStringId());
            ++this.failures;
            this.navs.put(this.from(), this.to(), false);
            this.increaseNavIndexTo();
            this.respawn();
        } else {
            this.pathExecutor.followPath(this.pathPlanner.computePath(this.to()));
        }
    }

    protected void nextNavPointReached() {
        NavPoint nav = this.info.getNearestNavPoint();
        if (!this.navs.get(this.from()).containsKey(nav)) {
            this.navs.put(this.from(), nav, true);
            this.user.info("SUCCEEDED ALONG THE WAY: " + this.from().getId().getStringId() + " -> " + this.to().getId().getStringId());
        }
        for (NavPoint pathNav : this.pathNavs) {
            if (this.navs.get(pathNav).containsKey(nav)) continue;
            this.navs.put(pathNav, nav, true);
            this.user.info("SUCCEEDED ALONG THE WAY: " + pathNav.getId().getStringId() + " -> " + this.to().getId().getStringId());
        }
        this.pathNavs.add(nav);
    }

    protected void targetReached() {
        this.user.info("SUCCEEDED: " + this.from().getId().getStringId() + " -> " + this.to().getId().getStringId());
        this.navs.put(this.from(), this.to(), true);
        this.increaseNavIndexTo();
        this.respawn();
    }

    private void pathBroken() {
        ++this.pathBroken;
        if (this.pathBroken > 2) {
            this.user.warning("PATH BROKEN: " + this.from().getId().getStringId() + " -> " + this.to().getId().getStringId());
            ++this.failuresPathBroken;
            this.navs.put(this.from(), this.to(), false);
            this.increaseNavIndexTo();
            this.respawn();
        }
    }

    @Override
    public void botKilled(BotKilled event) {
        this.pathExecutor.stop();
        this.move.stopMovement();
    }

    @Override
    public void botShutdown() {
        FileWriter writer;
        File file = new File("ExploreBot" + BOT_NUMBER + ".result.txt");
        try {
            writer = new FileWriter(file);
        }
        catch (IOException e1) {
            e1.printStackTrace();
            throw new PogamutIOException(e1, (Object)this);
        }
        PrintWriter print = new PrintWriter(writer);
        if (this.navs1Index >= this.navs1.size()) {
            print.println("COMPLETED");
            print.println("Total paths:   " + (this.navs1.size() * this.navs1.size() - 1));
            print.println("Visited paths: " + (this.navs1.size() * this.navs1.size() - 1));
        } else {
            print.println("PARTIAL");
            print.println("Total paths:   " + (this.navs1.size() * this.navs1.size() - 1));
            print.println("Visited paths: " + (this.navs1Index * this.navs1.size() + this.navs2Index));
        }
        print.println();
        print.println("Broken paths:");
        for (NavPoint from : this.navs.keySet()) {
            for (NavPoint to : this.navs.get(from).keySet()) {
                if (this.navs.get(from, to).booleanValue()) continue;
                print.println(String.valueOf(from.getId().getStringId()) + " -> " + to.getId().getStringId());
            }
        }
        try {
            writer.close();
        }
        catch (IOException e) {
            this.user.info("RESULT SAVE FAILED");
            e.printStackTrace();
        }
        this.user.info("Result saved writter.");
    }

    public static void main(String[] args) throws PogamutException {
        new SingleUT2004BotRunner(ExplorerBot.class, "ExploreBot").startAgent();
    }
}

