/*
 * Decompiled with CFR 0.152.
 */
package emodoctor;

import cz.cuni.amis.pogamut.base.agent.navigation.PathEventType;
import cz.cuni.amis.pogamut.base.agent.navigation.PathExecutorListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectClassEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.event.WorldObjectAppearedEvent;
import cz.cuni.amis.pogamut.ut2004.agent.module.utils.TabooSet;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.ItemType;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.FactoryUse;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.FactoryUsed;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Item;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ItemPickedUp;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.utils.SingleUT2004BotRunner;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.exception.PogamutException;
import java.util.ArrayList;
import java.util.List;

public class EmoDoctor
extends UT2004BotModuleController {
    public static final int ADRENALINE_RESPAWN_TIME = 60;
    public static final int ITEM_RESPAWN_TIME = 20;
    public static final double TURNING_INTERVAL = 1.2;
    public static final double ATTACK_ENEMY_DISTANCE = 450.0;
    public static final int FIGHTING_PATH_REPLAN = 3;
    State state = State.COLLECTING;
    TabooSet<NavPoint> seenNavs;
    TabooSet<Item> tabooAdrenalines;
    TabooSet<Item> tabooItems;
    List<Item> adrenalines = new ArrayList<Item>();
    NavPoint factoryNavPoint;
    NavPoint disperserNavPoint;
    int nearLocationInterrupt = Integer.MAX_VALUE;
    Location pathTo = null;
    Item runningToItem = null;
    boolean mustFollowPath = false;
    double nextTurn = 1.2;
    int newPathToEnemy = 3;
    boolean factoryUseIssued = false;
    private boolean ignoreEnemy = false;

    @Override
    public void prepareBot(UT2004Bot bot) {
        this.seenNavs = new TabooSet(bot);
        this.tabooAdrenalines = new TabooSet(bot);
        this.tabooItems = new TabooSet(bot);
        this.pathExecutor.addPathListener(new PathExecutorListener(){

            @Override
            public void onEvent(PathEventType eventType) {
                switch (eventType) {
                    case BOT_STUCKED: {
                        EmoDoctor.this.botStuck();
                        break;
                    }
                    case PATH_ELEMENT_REACHED: {
                        EmoDoctor.this.pathElementReached();
                        break;
                    }
                    case TARGET_REACHED: {
                        EmoDoctor.this.targetReached();
                    }
                }
            }
        });
    }

    @Override
    public Initialize getInitializeCommand() {
        return new Initialize().setName("EmoDoctor");
    }

    @Override
    public void botInitialized(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init) {
        this.factoryNavPoint = DistanceUtils.getNearest(this.world.getAll(NavPoint.class).values(), gameInfo.getFactoryLocation());
        this.disperserNavPoint = DistanceUtils.getNearest(this.world.getAll(NavPoint.class).values(), gameInfo.getDisperserLocation());
    }

    @Override
    public void botSpawned(GameInfo gameInfo, ConfigChange currentConfig, InitedMessage init, Self self) {
    }

    @ObjectClassEventListener(eventClass=WorldObjectFirstEncounteredEvent.class, objectClass=Item.class)
    public void itemEncountered(WorldObjectFirstEncounteredEvent<Item> event) {
        if (((Item)event.getObject()).isDropped()) {
            return;
        }
        NavPoint nav = DistanceUtils.getNearest(this.world.getAll(NavPoint.class).values(), (ILocated)event.getObject());
        nav.setItem((Item)event.getObject());
        ((Item)event.getObject()).setNavPoint(nav);
        if (((Item)event.getObject()).getType() == ItemType.ADRENALINE_PACK) {
            this.user.info("Adrenaline encountered: " + ((Item)event.getObject()).getId());
            this.adrenalines.add((Item)event.getObject());
        } else if (((Item)event.getObject()).getType() == ItemType.FLAK_CANNON) {
            this.user.info("Flak cannon encountered: " + ((Item)event.getObject()).getId());
        } else if (((Item)event.getObject()).getType() == ItemType.FLAK_CANNON_AMMO) {
            this.user.info("Ammo encountered: " + ((Item)event.getObject()).getId());
        }
    }

    @ObjectClassEventListener(eventClass=WorldObjectAppearedEvent.class, objectClass=NavPoint.class)
    public void navPointAppeared(WorldObjectAppearedEvent<NavPoint> event) {
        this.seenNavs.add((NavPoint)event.getObject());
    }

    @EventListener(eventClass=FactoryUsed.class)
    public void factoryUsed(FactoryUsed event) {
        this.factoryUseIssued = false;
        if (event.isSuccess()) {
            this.user.info("FACTORY SUCESSFULLY USED");
            this.state = State.DISPERSER;
        } else {
            this.user.severe("FACTORY USE FAILURE: " + event.getReason());
            this.state = State.COLLECTING;
        }
    }

    @EventListener(eventClass=ItemPickedUp.class)
    public void itemPickedUp(ItemPickedUp event) {
        if (event.getType() == ItemType.ADRENALINE_PACK) {
            this.user.info("Adrenaline picked up!");
            this.tabooAdrenalines.add(this.getItem(event.getId()), 60.0);
        } else {
            this.tabooItems.add(this.getItem(event.getId()), 20.0);
            if (event.getType() == ItemType.FLAK_CANNON) {
                this.user.info("Flak cannon picked up.");
                this.weaponry.changeWeapon(ItemType.FLAK_CANNON);
            } else if (event.getType() == ItemType.FLAK_CANNON_AMMO) {
                this.user.info("Ammo picked up!");
            }
            Item item = this.world.getAll(Item.class).get(event.getId());
            if (item.isDropped()) {
                this.tabooItems.add(item);
            }
        }
    }

    @EventListener(eventClass=EndMessage.class)
    public void endMessage(EndMessage event) {
        for (NavPoint nav : this.world.getAllVisible(NavPoint.class).values()) {
            if (nav.getItem() == null || this.world.getAllVisible(Item.class).containsKey(nav.getItem())) continue;
            Item item = this.world.getAll(Item.class).get(nav.getItem());
            if (item == null) {
                return;
            }
            if (this.tabooItems.isTaboo(item) || this.tabooAdrenalines.isTaboo(item)) continue;
            if (item == this.runningToItem) {
                this.user.warning("Running for item that is not spawned! Stopping the movement.");
                this.pathExecutor.stop();
                this.runningToItem = null;
                this.pathTo = null;
            }
            if (item.getType() == ItemType.ADRENALINE_PACK) {
                this.tabooAdrenalines.add(item, 20.0);
                continue;
            }
            this.tabooItems.add(item, 20.0);
        }
    }

    public boolean atFactory() {
        return this.world.getSingle(GameInfo.class).getFactoryLocation().getDistance(this.info.getLocation()) < this.world.getSingle(GameInfo.class).getFactoryRadius();
    }

    public boolean atDisperser() {
        return this.world.getSingle(GameInfo.class).getDisperserLocation().getDistance(this.info.getLocation()) < this.world.getSingle(GameInfo.class).getDisperserRadius();
    }

    public NavPoint atNavPoint() {
        return DistanceUtils.getNearest(this.world.getAll(NavPoint.class).values(), this.info.getLocation());
    }

    public Item getItem(UnrealId id) {
        return this.world.getAll(Item.class).get(id);
    }

    public NavPoint pickNextNavPoint() {
        NavPoint nav = MyCollections.getRandom(this.seenNavs.filter(this.world.getAll(NavPoint.class).values()));
        if (nav != null) {
            this.user.info("Picking unexplored navpoint: " + nav.getId().getStringId());
            return nav;
        }
        this.user.info("All navpoints have been explored, seeking adrenalines.");
        Item item = DistanceUtils.getNearest(this.tabooAdrenalines.filter(this.adrenalines), this.info.getLocation());
        if (item != null) {
            this.user.info("Running for the adrenaline: " + item.getId().getStringId());
            return item.getNavPoint();
        }
        this.user.info("No adrenaline to run to... picking one at random.");
        item = MyCollections.getRandom(this.adrenalines);
        return item.getNavPoint();
    }

    public boolean hasWeapon() {
        return this.weaponry.getCurrentWeapon() != null;
    }

    public boolean hasSufficientAmmo() {
        int ammo = this.weaponry.getAmmo(ItemType.FLAK_CANNON_AMMO);
        return ammo >= 2;
    }

    public boolean needWeapon() {
        return !this.weaponry.hasWeapon(ItemType.FLAK_CANNON) || this.weaponry.getAmmo(ItemType.FLAK_CANNON_AMMO) < 2;
    }

    public boolean needAmmo() {
        return !this.hasSufficientAmmo();
    }

    public boolean wantSwitchToItem(Item item) {
        if (this.mustFollowPath) {
            return false;
        }
        if (this.runningToItem == null) {
            return true;
        }
        if (this.needWeapon()) {
            if (item.getType() != ItemType.FLAK_CANNON) {
                return false;
            }
            if (this.runningToItem.getType() == ItemType.FLAK_CANNON) {
                return this.pathTo.getLocation().getDistance(this.info.getLocation()) * 0.8 > item.getLocation().getDistance(this.info.getLocation());
            }
            return false;
        }
        if (this.needAmmo()) {
            if (item.getType() != ItemType.FLAK_CANNON && item.getType() != ItemType.FLAK_CANNON_AMMO) {
                return true;
            }
            if (this.runningToItem.getType() == ItemType.FLAK_CANNON || this.runningToItem.getType() == ItemType.FLAK_CANNON_AMMO) {
                return this.pathTo.getLocation().getDistance(this.info.getLocation()) * 0.8 > item.getLocation().getDistance(this.info.getLocation());
            }
            return false;
        }
        if (this.needAdrenaline()) {
            if (this.runningToItem.getType() == ItemType.ADRENALINE_PACK) {
                return this.pathTo.getLocation().getDistance(this.info.getLocation()) * 0.8 > item.getLocation().getDistance(this.info.getLocation());
            }
            if (item.getType() == ItemType.ADRENALINE_PACK) {
                return true;
            }
        }
        return false;
    }

    public Item knowWeaponLocation() {
        double distanceNearest = Double.MAX_VALUE;
        Item itemNearest = null;
        for (Item item : this.tabooItems.filter(this.world.getAll(Item.class).values())) {
            double distance;
            if (item.getType().getCategory() != ItemType.Category.WEAPON || !((distance = item.getLocation().getDistance(this.info.getLocation())) < distanceNearest)) continue;
            distanceNearest = distance;
            itemNearest = item;
        }
        return itemNearest;
    }

    public Item knowWeaponOrAmmoLocation() {
        double distanceNearest = Double.MAX_VALUE;
        Item itemNearest = null;
        for (Item item : this.tabooItems.filter(this.world.getAll(Item.class).values())) {
            double distance;
            if (item.getType().getCategory() != ItemType.Category.WEAPON && item.getType().getCategory() != ItemType.Category.AMMO || !((distance = item.getLocation().getDistance(this.info.getLocation())) < distanceNearest)) continue;
            distanceNearest = distance;
            itemNearest = item;
        }
        return itemNearest;
    }

    public Item knowAdrenalineLocation() {
        double distanceNearest = Double.MAX_VALUE;
        Item itemNearest = null;
        for (Item item : this.tabooAdrenalines.filter(this.adrenalines)) {
            double distance = item.getLocation().getDistance(this.info.getLocation());
            if (!(distance < distanceNearest)) continue;
            distanceNearest = distance;
            itemNearest = item;
        }
        return itemNearest;
    }

    public boolean hasEnoughAdrenaline() {
        return this.world.getSingle(GameInfo.class).getFactoryAdrenalineCount() <= (double)this.info.getAdrenaline();
    }

    public boolean hasUDamage() {
        return this.info.hasUDamage();
    }

    public boolean needAdrenaline() {
        return !this.hasEnoughAdrenaline();
    }

    @Override
    public void logic() throws PogamutException {
        this.user.severe("---=== LOGIC ===---");
        this.user.info("UDamage:      " + this.info.hasUDamage());
        if (this.info.hasUDamage()) {
            this.user.info("UDamage time: " + this.info.getRemainingUDamageTime());
        }
        this.user.info("Adrenalines:  " + this.info.getAdrenaline());
        this.user.info("Weapon:       " + this.weaponry.getCurrentWeapon());
        this.user.info("Ammo:         " + this.weaponry.getCurrentAmmo());
        if (this.runningToItem != null) {
            this.user.info("Running for:  " + this.runningToItem.getType().getName());
        }
        if (this.pathTo != null) {
            this.user.info("Path len:     " + this.pathTo.getDistance(this.info.getLocation()));
        }
        this.user.warning("State:        " + (Object)((Object)this.state));
        if (!this.players.canSeeEnemies() && this.info.isShooting()) {
            this.shoot.stopShooting();
        }
        this.config.setName("EmoDoctor [" + (Object)((Object)this.state) + "]");
        switch (this.state) {
            case COLLECTING: {
                this.nextMoveCollectingAdrenaline();
                break;
            }
            case FIGHTING: {
                this.nextMoveFighting();
                break;
            }
            case DISPERSER: {
                this.nextMoveRunningToDisperser();
                break;
            }
            case FACTORY: {
                this.nextMoveRunningToFactory();
            }
        }
    }

    private void runToItem(Item item) {
        this.user.info("Switching for item: " + item.getType().getName());
        this.user.info("Distance:           " + item.getLocation().getDistance(this.info.getLocation()));
        this.pathExecutor.stop();
        this.pathTo = item.getLocation();
        this.runningToItem = item;
        this.mustFollowPath = false;
        this.pathExecutor.followPath(this.pathPlanner.computePath(item));
    }

    private boolean observe() {
        Item item;
        if (this.players.canSeeEnemies()) {
            this.move.turnTo(this.players.getNearestVisibleEnemy());
            Player enemy = this.players.getNearestVisibleEnemy();
            if (this.hasWeapon() && this.info.getCurrentAmmo() > 0 && enemy.getLocation().getDistance(this.info.getLocation()) < 450.0) {
                this.shoot.shoot(enemy);
            }
        } else {
            Double timeDelta = this.senses.getTimeDelta();
            if (timeDelta != null) {
                this.nextTurn -= this.senses.getTimeDelta().doubleValue();
            }
            if (this.nextTurn < 0.0) {
                this.move.turnHorizontal(this.random.nextInt(360) - 180);
                this.nextTurn = 1.2;
            }
        }
        if (this.ignoreEnemy) {
            return false;
        }
        if (this.hasWeapon() && this.hasSufficientAmmo() && this.players.canSeeEnemies() && this.needAdrenaline()) {
            this.pathExecutor.stop();
            this.state = State.FIGHTING;
            this.logic();
            return true;
        }
        if (this.mustFollowPath) {
            return false;
        }
        if (this.needWeapon() && (item = this.knowWeaponLocation()) != null && this.wantSwitchToItem(item)) {
            this.runToItem(item);
            return true;
        }
        if (this.hasWeapon() && this.needAmmo() && (item = this.knowWeaponOrAmmoLocation()) != null && this.wantSwitchToItem(item)) {
            this.runToItem(item);
            return true;
        }
        if (this.needAdrenaline() && (item = this.knowAdrenalineLocation()) != null && this.wantSwitchToItem(item)) {
            this.runToItem(item);
            return true;
        }
        return false;
    }

    private void nextMoveCollectingAdrenaline() {
        this.ignoreEnemy = false;
        if (this.observe()) {
            return;
        }
        if (!this.pathExecutor.isMoving()) {
            NavPoint np = this.pickNextNavPoint();
            this.pathTo = np.getLocation();
            this.runningToItem = null;
            this.pathExecutor.followPath(this.pathPlanner.computePath(np));
        }
    }

    private void nextMoveRunningToFactory() {
        this.ignoreEnemy = true;
        if (!this.hasEnoughAdrenaline()) {
            this.state = State.COLLECTING;
            this.logic();
            return;
        }
        if (!this.pathExecutor.isMoving()) {
            this.pathExecutor.followPath(this.pathPlanner.computePath(this.factoryNavPoint));
            this.pathTo = this.factoryNavPoint.getLocation();
            this.runningToItem = null;
            this.mustFollowPath = true;
        }
        this.observe();
        Player enemy = this.players.getNearestVisibleEnemy();
        if (enemy.getLocation().getDistance(this.info.getLocation()) < 450.0) {
            this.shoot.shoot(enemy);
        }
        if (this.atFactory() && !this.factoryUseIssued) {
            this.getAct().act(new FactoryUse());
            this.factoryUseIssued = true;
        }
    }

    private void nextMoveRunningToDisperser() {
        this.ignoreEnemy = true;
        if (!this.hasUDamage()) {
            this.state = State.COLLECTING;
            this.logic();
            return;
        }
        if (!this.pathExecutor.isMoving()) {
            this.pathExecutor.followPath(this.pathPlanner.computePath(this.disperserNavPoint));
            this.pathTo = this.disperserNavPoint.getLocation();
            this.runningToItem = null;
            this.mustFollowPath = true;
        }
        this.observe();
        if (this.atDisperser()) {
            this.user.info("VICTORY!!! At disperser + has UDamage!!!");
            this.bot.stop();
        }
    }

    private void nextMoveFighting() {
        Player enemy;
        this.ignoreEnemy = true;
        if (this.needWeapon()) {
            this.pathExecutor.stop();
            this.state = State.COLLECTING;
            this.logic();
            return;
        }
        if (this.weaponry.getAmmo(ItemType.FLAK_CANNON_AMMO) == 0) {
            this.pathExecutor.stop();
            this.state = State.COLLECTING;
            this.logic();
            return;
        }
        if (this.players.canSeeEnemies() && (enemy = this.players.getNearestVisibleEnemy()).getLocation().getDistance(this.info.getLocation()) < 450.0) {
            this.pathExecutor.stop();
            this.move.stopMovement();
            this.shoot.shoot(enemy);
            return;
        }
        if (!this.pathExecutor.isMoving()) {
            if (!this.players.canSeeEnemies()) {
                this.state = State.COLLECTING;
                this.logic();
                return;
            }
            enemy = this.players.getNearestVisibleEnemy();
            this.pathExecutor.followPath(this.pathPlanner.computePath(enemy));
            this.pathTo = enemy.getLocation();
            this.runningToItem = null;
            this.newPathToEnemy = 3;
        }
        this.observe();
    }

    protected void pathElementReached() {
        if (this.state == State.FIGHTING) {
            if (this.players.canSeeEnemies()) {
                --this.newPathToEnemy;
                if (this.newPathToEnemy == 0) {
                    Player enemy = this.players.getNearestVisibleEnemy();
                    this.newPathToEnemy = 3;
                    this.pathExecutor.followPath(this.pathPlanner.computePath(enemy));
                    this.pathTo = enemy.getLocation();
                    this.runningToItem = null;
                }
            } else {
                this.state = State.COLLECTING;
            }
        }
    }

    protected void targetReached() {
        this.pathExecutor.stop();
        if (this.runningToItem != null) {
            this.move.moveTo(this.runningToItem);
        }
    }

    protected void botStuck() {
        this.pathExecutor.stop();
    }

    @Override
    public void botKilled(BotKilled event) {
        this.pathTo = null;
        this.runningToItem = null;
        this.nextTurn = 1.2;
        this.newPathToEnemy = 3;
        this.factoryUseIssued = false;
        this.state = State.COLLECTING;
        this.ignoreEnemy = false;
    }

    @Override
    public void botShutdown() {
    }

    public static void main(String[] args) throws PogamutException {
        new SingleUT2004BotRunner(EmoDoctor.class, "Main").startAgent();
    }

    static enum State {
        COLLECTING,
        FACTORY,
        DISPERSER,
        FIGHTING;

    }
}

