/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.token;

import cz.cuni.amis.utils.token.Token;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Tokens {
    private static volatile long[] lastIds = new long[0];
    private static Map<String, WeakReference<Token>> tokenMap = new HashMap<String, WeakReference<Token>>();
    private static final Token NULL_TOKEN = Tokens.get("null");

    public static synchronized Token get(String tokenStr) {
        if (tokenStr == null) {
            return NULL_TOKEN;
        }
        WeakReference<Token> refToken = tokenMap.get(tokenStr);
        Token token = null;
        if (refToken != null) {
            token = (Token)refToken.get();
        }
        if (token == null) {
            token = Tokens.newToken(tokenStr);
            tokenMap.put(tokenStr, new WeakReference<Token>(token));
        }
        return token;
    }

    public static synchronized Token get(long id) {
        WeakReference<Token> refToken = tokenMap.get(String.valueOf(id));
        Token token = null;
        if (refToken != null) {
            token = (Token)refToken.get();
        }
        if (token == null) {
            token = Tokens.newToken(id);
            tokenMap.put(String.valueOf(id), new WeakReference<Token>(token));
        }
        return token;
    }

    private static Token newToken(String tokenStr) {
        return new Token(tokenStr, Tokens.nextLastIds());
    }

    private static Token newToken(long tokenId) {
        return new Token(String.valueOf(tokenId), Tokens.nextLastIds());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long[] nextLastIds() {
        long[] lArray = lastIds;
        synchronized (lastIds) {
            int i = 0;
            while (i < lastIds.length) {
                if (lastIds[i] == Long.MAX_VALUE) {
                    Tokens.lastIds[i] = Long.MIN_VALUE;
                    break;
                }
                if (lastIds[i] != -1L) {
                    int n = i;
                    lastIds[n] = lastIds[n] + 1L;
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return lastIds;
                }
                Tokens.lastIds[i] = 0L;
                ++i;
            }
            lastIds = new long[lastIds.length + 1];
            Arrays.fill(lastIds, 0L);
            // ** MonitorExit[var0] (shouldn't be in output)
            return lastIds;
        }
    }
}

