/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.test;

import cz.cuni.amis.pogamut.base.utils.Const;
import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.StopWatch;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.test.ContextRunnable;
import cz.cuni.amis.utils.test.TestContext;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class Concurrent<CONTEXT extends TestContext>
implements ContextRunnable<CONTEXT> {
    private final int threadCount;
    protected final ContextRunnable tester;
    private Object mutex = new Object();
    private List<Exception> list = new ArrayList<Exception>();

    public Concurrent(int threads, ContextRunnable tester) {
        this.tester = tester;
        NullCheck.check(this.tester, "tester");
        this.threadCount = threads;
        if (this.threadCount <= 0) {
            throw new IllegalArgumentException("Number of threads must be > 0.");
        }
    }

    protected Runnable newTest(CONTEXT ctx) {
        return new Runnable((TestContext)ctx){
            private final /* synthetic */ TestContext val$ctx;
            {
                this.val$ctx = testContext;
            }

            @Override
            public void run() {
                Concurrent.this.tester.run(this.val$ctx);
            }
        };
    }

    private Runnable trueNewTest(CONTEXT ctx) {
        final Runnable myRunnable = this.newTest(ctx);
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    myRunnable.run();
                }
                catch (Exception e) {
                    Object object = Concurrent.this.mutex;
                    synchronized (object) {
                        Concurrent.this.list.add(e);
                    }
                }
            }
        };
    }

    @Override
    public void run(CONTEXT ctx) {
        Logger log = ((TestContext)ctx).getLog();
        Thread[] threads = new Thread[this.threadCount];
        int i = 0;
        while (i < threads.length) {
            threads[i] = new Thread(this.trueNewTest(ctx), "Test" + i);
            ++i;
        }
        StopWatch watch = new StopWatch();
        int i2 = 0;
        while (i2 < threads.length) {
            log.log(log.getLevel(), "Starting thread " + (i2 + 1) + " / " + threads.length + ".");
            threads[i2].start();
            ++i2;
        }
        try {
            i2 = 0;
            while (i2 < threads.length) {
                threads[i2].join();
                ++i2;
            }
            log.log(log.getLevel(), "All " + threads.length + " threads finished in " + watch.stopStr() + ".");
        }
        catch (InterruptedException e) {
            throw new PogamutInterruptedException(e, (Object)this);
        }
        if (this.list.size() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(Const.NEW_LINE);
            sb.append("Exceptions:");
            for (Exception e : this.list) {
                sb.append(Const.NEW_LINE);
                sb.append("    " + e.getClass().getSimpleName() + ": " + e.getMessage());
            }
            log.severe(sb.toString());
            log.severe("Test failed due to previous errors...");
            throw new RuntimeException("Test failed due to previous errors...");
        }
    }
}

