/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.jmx.flag;

import cz.cuni.amis.pogamut.base.utils.jmx.PogamutJMX;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.FlagListener;
import cz.cuni.amis.utils.jmx.flag.JMXFlagDecoratorMBean;
import java.io.Serializable;
import javax.management.InstanceAlreadyExistsException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class JMXFlagDecorator<T extends Serializable>
implements JMXFlagDecoratorMBean,
NotificationEmitter {
    protected Flag<T> flag = null;
    protected ObjectName source;
    protected int eventCounter = 0;
    protected String flagName = null;
    protected FlagListener<T> listener = new FlagListener<T>(){

        @Override
        public void flagChanged(T changedValue) {
            Notification notification = new Notification(JMXFlagDecorator.this.flagName, (Object)JMXFlagDecorator.this.source, (long)JMXFlagDecorator.this.eventCounter++, changedValue.toString());
            notification.setUserData(JMXFlagDecorator.this.flag.getFlag());
            JMXFlagDecorator.this.nbs.sendNotification(notification);
        }
    };
    protected NotificationBroadcasterSupport nbs = new NotificationBroadcasterSupport();

    public JMXFlagDecorator(Flag<T> flag, ObjectName source, MBeanServer mbs, String flagName) throws MalformedObjectNameException, InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        this.flag = flag;
        this.source = source;
        this.flagName = flagName;
        ObjectName name = PogamutJMX.getObjectName(source, flagName, "flags");
        mbs.registerMBean(this, name);
        flag.addListener(this.listener);
    }

    public void stop() {
        this.flag.removeListener(this.listener);
    }

    public MBeanNotificationInfo getMBeanNotificationInfo() {
        return new MBeanNotificationInfo(new String[]{this.flagName}, Notification.class.getName(), "The flag has changed it's value.");
    }

    @Override
    public Serializable getFlag() {
        return (Serializable)this.flag.getFlag();
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.nbs.removeNotificationListener(listener, filter, handback);
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.nbs.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.nbs.removeNotificationListener(listener);
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[]{this.getMBeanNotificationInfo()};
    }
}

