/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.future;

import cz.cuni.amis.utils.NullCheck;
import cz.cuni.amis.utils.TimeUnitToMillis;
import cz.cuni.amis.utils.exception.PogamutTimeoutException;
import cz.cuni.amis.utils.future.IFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class CombinedBooleanFuture
implements IFuture<Boolean> {
    private IFuture<Boolean>[] futures;

    public CombinedBooleanFuture(IFuture<Boolean>[] futures) {
        this.futures = futures;
        NullCheck.check(this.futures, "futures");
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean canceled = true;
        IFuture<Boolean>[] iFutureArray = this.futures;
        int n = this.futures.length;
        int n2 = 0;
        while (n2 < n) {
            IFuture<Boolean> future = iFutureArray[n2];
            canceled = canceled && future.cancel(mayInterruptIfRunning);
            ++n2;
        }
        return canceled;
    }

    @Override
    public Boolean get() {
        boolean result = true;
        IFuture<Boolean>[] iFutureArray = this.futures;
        int n = this.futures.length;
        int n2 = 0;
        while (n2 < n) {
            IFuture<Boolean> future = iFutureArray[n2];
            Boolean futureResult = future.get();
            result = result && futureResult != null && futureResult != false;
            ++n2;
        }
        return result;
    }

    @Override
    public Boolean get(long timeout, TimeUnit unit) {
        long timeoutMillis = TimeUnitToMillis.toMillis(timeout, unit);
        long start = System.currentTimeMillis();
        boolean result = true;
        IFuture<Boolean>[] iFutureArray = this.futures;
        int n = this.futures.length;
        int n2 = 0;
        while (n2 < n) {
            IFuture<Boolean> future = iFutureArray[n2];
            long futureStart = System.currentTimeMillis();
            if (futureStart - start > timeoutMillis) {
                throw new PogamutTimeoutException("timeouted after " + timeout + " " + (Object)((Object)unit), (Object)this);
            }
            Boolean futureResult = future.get(timeoutMillis - (futureStart - start), TimeUnit.MILLISECONDS);
            result = result && futureResult != null && futureResult != false;
            ++n2;
        }
        return result;
    }

    public Boolean[] getAll(long timeout, TimeUnit unit) {
        long timeoutMillis = TimeUnitToMillis.toMillis(timeout, unit);
        long start = System.currentTimeMillis();
        Boolean[] results = new Boolean[this.futures.length];
        int i = 0;
        IFuture<Boolean>[] iFutureArray = this.futures;
        int n = this.futures.length;
        int n2 = 0;
        while (n2 < n) {
            IFuture<Boolean> future = iFutureArray[n2];
            long futureStart = System.currentTimeMillis();
            if (futureStart - start > timeoutMillis) {
                throw new PogamutTimeoutException("timeouted after " + timeout + " " + (Object)((Object)unit), (Object)this);
            }
            results[i++] = future.get(timeoutMillis - (futureStart - start), TimeUnit.MILLISECONDS);
            ++n2;
        }
        return results;
    }

    @Override
    public boolean isCancelled() {
        boolean result = false;
        IFuture<Boolean>[] iFutureArray = this.futures;
        int n = this.futures.length;
        int n2 = 0;
        while (n2 < n) {
            IFuture<Boolean> future = iFutureArray[n2];
            Boolean futureResult = future.isCancelled();
            result = result || futureResult != null && futureResult != false;
            ++n2;
        }
        return result;
    }

    @Override
    public boolean isDone() {
        boolean result = true;
        IFuture<Boolean>[] iFutureArray = this.futures;
        int n = this.futures.length;
        int n2 = 0;
        while (n2 < n) {
            IFuture<Boolean> future = iFutureArray[n2];
            result = result && future.isDone();
            ++n2;
        }
        return result;
    }

    public Future<Boolean>[] getFutures() {
        return this.futures;
    }
}

