/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.flag;

import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.FlagListener;
import cz.cuni.amis.utils.flag.IReasonFlag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import cz.cuni.amis.utils.flag.ImmutableReasonFlag;
import cz.cuni.amis.utils.flag.ReasonFlagListener;

public class ReasonFlag<TYPE, REASON>
extends Flag<TYPE>
implements IReasonFlag<TYPE, REASON> {
    public ReasonFlag() {
        this(null);
    }

    public ReasonFlag(TYPE initialValue) {
        super(initialValue);
        this.notifier = new ReasonFlagListener.ReasonFlagListenerNotifier();
    }

    @Override
    public void setFlag(TYPE newValue, REASON reasonForChange) {
        this.inSyncInner(new SetInSyncWithReason(newValue, reasonForChange), false);
    }

    @Override
    public void addStrongListener(FlagListener<TYPE> listener) {
        super.addStrongListener(listener);
    }

    @Override
    public void addListener(FlagListener<TYPE> listener) {
        super.addListener(listener);
    }

    public static void main(String[] args) {
        ReasonFlag<Boolean, DummyReason> flag = new ReasonFlag<Boolean, DummyReason>(false);
        ReasonFlagListener<Boolean, DummyReason> listener1 = new ReasonFlagListener<Boolean, DummyReason>(){

            @Override
            public void flagChanged(Boolean changedValue, DummyReason reason) {
                System.out.println("1 -> " + changedValue + " because " + (Object)((Object)reason));
            }

            @Override
            public void flagChanged(Boolean changedValue) {
                System.out.println("1 -> " + changedValue);
            }
        };
        ReasonFlagListener<Boolean, DummyReason> listener2 = new ReasonFlagListener<Boolean, DummyReason>(){

            @Override
            public void flagChanged(Boolean changedValue, DummyReason reason) {
                System.out.println("2 -> " + changedValue + " because " + (Object)((Object)reason));
            }

            @Override
            public void flagChanged(Boolean changedValue) {
                System.out.println("2 -> " + changedValue);
            }
        };
        FlagListener<Boolean> listener3 = new FlagListener<Boolean>(){

            @Override
            public void flagChanged(Boolean changedValue) {
                System.out.println("3 -> " + changedValue);
            }
        };
        flag.addListener((FlagListener<Boolean>)listener1);
        flag.addListener((FlagListener<Boolean>)listener2);
        flag.addListener(listener3);
        flag.setFlag(true);
        flag.setFlag(false, DummyReason.UPDATE);
        flag.setFlag(true);
        flag.setFlag(false, DummyReason.FAILURE);
    }

    public ImmutableReasonFlag<TYPE, REASON> getImmutable() {
        if (this.immutableWrapper == null) {
            this.immutableWrapper = new ImmutableReasonFlag(this);
        }
        return (ImmutableReasonFlag)this.immutableWrapper;
    }

    private static enum DummyReason {
        NEW,
        UPDATE,
        FAILURE;

    }

    class SetInSyncWithReason
    extends Flag.SetInSync {
        private REASON reason;

        public SetInSyncWithReason(TYPE newValue, REASON reason) {
            super(newValue);
            this.newValue = newValue;
            this.reason = reason;
        }

        @Override
        public void execute(TYPE flagValue) {
            if (this.newValue == null && flagValue != null || !this.newValue.equals(flagValue)) {
                if (this.flag instanceof ImmutableFlag) {
                    throw new UnsupportedOperationException("trying to set flag of the immutable flag!");
                }
                this.flag.value = this.newValue;
                this.flag.notifier.setValue(this.newValue);
                if (this.flag instanceof ReasonFlag) {
                    ((ReasonFlagListener.ReasonFlagListenerNotifier)this.flag.notifier).setReason(this.reason);
                    this.flag.listeners.notify(this.flag.notifier);
                    ((ReasonFlagListener.ReasonFlagListenerNotifier)this.flag.notifier).setReason(null);
                } else {
                    this.flag.listeners.notify(this.flag.notifier);
                }
            }
        }
    }
}

