/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils.flag;

import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.FlagListener;
import cz.cuni.amis.utils.flag.IFlag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import cz.cuni.amis.utils.flag.WaitForFlagChange;
import cz.cuni.amis.utils.listener.Listeners;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class Flag<T>
implements IFlag<T> {
    Listeners<FlagListener<T>> listeners = new Listeners();
    T value;
    FlagListener.FlagListenerNotifier<T> notifier = new FlagListener.FlagListenerNotifier();
    Object setMutex = new Object();
    boolean setFreezed = false;
    Object setFreezedMutex = new Object();
    Semaphore setFreezedSemaphore = new Semaphore(1);
    Semaphore commandQueueProcessing = new Semaphore(1);
    Object commandQueueProcessingMutex = new Object();
    List<DoInSync<T>> commandQueue = new LinkedList<DoInSync<T>>();
    ImmutableFlag<T> immutableWrapper = null;

    public Flag() {
        this.value = null;
    }

    public Flag(T initialValue) {
        this.value = initialValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processCommandQueue() {
        while (true) {
            DoInSync<T> command = null;
            Object object = this.commandQueue;
            synchronized (object) {
                if (this.commandQueue.size() != 0) {
                    command = this.commandQueue.get(0);
                    this.commandQueue.remove(0);
                }
            }
            if (command != null) {
                command.setFlagInstance(this);
                command.execute(this.value);
            }
            object = this.commandQueueProcessingMutex;
            synchronized (object) {
                if (this.commandQueue.size() == 0) {
                    this.commandQueueProcessing.release();
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void inSyncInner(DoInSync<T> command, boolean addAsFirst) {
        Object object = this.setMutex;
        synchronized (object) {
            List<DoInSync<T>> list = this.commandQueue;
            synchronized (list) {
                Object object2 = this.commandQueueProcessingMutex;
                synchronized (object2) {
                    Object object3 = this.setFreezedMutex;
                    synchronized (object3) {
                        if (addAsFirst) {
                            this.commandQueue.add(0, command);
                        } else {
                            this.commandQueue.add(command);
                        }
                        if (this.setFreezed) {
                            return;
                        }
                        if (this.commandQueueProcessing.availablePermits() <= 0) {
                            return;
                        }
                        try {
                            this.commandQueueProcessing.acquire();
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                }
            }
        }
        this.processCommandQueue();
    }

    @Override
    public void inSync(DoInSync<T> command) {
        this.inSyncInner(command, false);
    }

    @Override
    public void setFlag(T newValue) {
        this.inSyncInner(new SetInSync(newValue), false);
    }

    @Override
    public boolean isFrozen() {
        return this.setFreezed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeze() {
        try {
            this.setFreezedSemaphore.acquire();
        }
        catch (InterruptedException e) {
            throw new PogamutInterruptedException("wait on the freeze semapthore has been interrupter", e, (Object)this);
        }
        Object e = this.setFreezedMutex;
        synchronized (e) {
            this.setFreezed = true;
        }
        try {
            this.commandQueueProcessing.acquire();
            this.commandQueueProcessing.release();
        }
        catch (InterruptedException e2) {
            throw new PogamutInterruptedException("interrupted during the wait for the setFlag() to finish it's work", e2, (Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void defreeze() {
        Object object = this.commandQueueProcessingMutex;
        synchronized (object) {
            try {
                this.commandQueueProcessing.acquire();
            }
            catch (InterruptedException e) {
                throw new PogamutInterruptedException("interrupted during acquiring setFlagProcessing", e, (Object)this);
            }
        }
        object = this.setFreezedMutex;
        synchronized (object) {
            if (!this.setFreezed) {
                throw new PogamutException("flag has been defreezed twice", (Object)this);
            }
            this.setFreezed = false;
        }
        this.processCommandQueue();
        this.setFreezedSemaphore.release();
    }

    public T waitForChange() throws PogamutInterruptedException {
        return (T)new WaitForFlagChange(this).await();
    }

    public T waitForChange(long timeoutMillis) throws PogamutInterruptedException {
        return (T)new WaitForFlagChange(this).await(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    public T waitFor(T ... oneOfTheValue) throws PogamutInterruptedException {
        return new WaitForFlagChange<T>(this, (TYPE[])oneOfTheValue).await();
    }

    public T waitFor(long timeoutMillis, T ... oneOfTheValue) throws PogamutInterruptedException {
        return new WaitForFlagChange<T>(this, (TYPE[])oneOfTheValue).await(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getFlag() {
        Object object = this.setMutex;
        synchronized (object) {
            List<DoInSync<T>> list = this.commandQueue;
            synchronized (list) {
                if (this.commandQueue.size() != 0) {
                    int i = this.commandQueue.size() - 1;
                    while (i >= 0) {
                        DoInSync<T> command = this.commandQueue.get(i);
                        if (command instanceof SetInSync) {
                            return ((SetInSync)command).newValue;
                        }
                        --i;
                    }
                }
                return this.value;
            }
        }
    }

    @Override
    public ImmutableFlag<T> getImmutable() {
        if (this.immutableWrapper == null) {
            this.immutableWrapper = new ImmutableFlag(this);
        }
        return this.immutableWrapper;
    }

    @Override
    public void addStrongListener(FlagListener<T> listener) {
        if (listener == null) {
            return;
        }
        this.listeners.addStrongListener(listener);
    }

    @Override
    public void addListener(FlagListener<T> listener) {
        if (listener == null) {
            return;
        }
        this.listeners.addStrongListener(listener);
    }

    @Override
    public void removeListener(FlagListener<T> listener) {
        if (listener == null) {
            return;
        }
        this.listeners.removeEqualListener(listener);
    }

    @Override
    public void removeAllListeners() {
        this.listeners.clearListeners();
    }

    @Override
    public boolean isListenning(FlagListener<T> listener) {
        if (listener == null) {
            return false;
        }
        return this.listeners.isEqualListening(listener);
    }

    @Override
    public void clearListeners() {
        this.listeners.clearListeners();
    }

    public static void main(String[] args) {
        Flag<Boolean> flag = new Flag<Boolean>(true);
        FlagListener<Boolean> fl1 = new FlagListener<Boolean>(){

            @Override
            public void flagChanged(Boolean changedValue) {
                System.out.println("1 FIRED, new value = " + changedValue.toString());
            }
        };
        FlagListener<Boolean> fl2 = new FlagListener<Boolean>(){

            @Override
            public void flagChanged(Boolean changedValue) {
                System.out.println("2 FIRED, new value = " + changedValue.toString());
            }
        };
        FlagListener<Boolean> fl3 = new FlagListener<Boolean>(){

            @Override
            public void flagChanged(Boolean changedValue) {
                System.out.println("3 FIRED, new value = " + changedValue.toString());
            }
        };
        System.out.println("Expecting: 1");
        flag.addListener(fl1);
        flag.setFlag(false);
        flag.setFlag(false);
        System.out.println("");
        System.out.println("Expecting: 1,2");
        flag.addListener(fl2);
        flag.setFlag(true);
        flag.setFlag(true);
        System.out.println("");
        System.out.println("Expecting: 1,2,3");
        flag.addListener(fl3);
        flag.setFlag(false);
        flag.setFlag(false);
        System.out.println("");
        System.out.println("Expecting: 2,3");
        flag.removeListener(fl1);
        flag.setFlag(true);
        flag.setFlag(true);
        System.out.println("");
        System.out.println("Expecting: 2");
        flag.removeListener(fl3);
        flag.setFlag(false);
        flag.setFlag(false);
        System.out.println("Expecting: none");
        flag.removeListener(fl2);
        flag.setFlag(true);
        flag.setFlag(true);
        System.out.println("");
        System.out.println("Race conditions... mustn't deadlock!");
        final CountDownLatch latch = new CountDownLatch(2);
        final CountDownLatch end = new CountDownLatch(2);
        Thread one = new Thread(new Runnable(){

            @Override
            public void run() {
                Flag.this.addListener(new FlagListener<Boolean>(){

                    @Override
                    public void flagChanged(Boolean changedValue) {
                        System.out.println("Thread 1: flag == " + changedValue);
                    }
                });
                latch.countDown();
                try {
                    latch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Thread 1: start");
                int i = 0;
                while (i < 100) {
                    boolean value = i % 2 == 0;
                    System.out.println("Thread 1: setting flag to " + value);
                    Flag.this.setFlag(value);
                    ++i;
                }
                end.countDown();
            }
        });
        Thread two = new Thread(new Runnable(){

            @Override
            public void run() {
                Flag.this.addListener(new FlagListener<Boolean>(){

                    @Override
                    public void flagChanged(Boolean changedValue) {
                        System.out.println("Thread 2: flag == " + changedValue);
                    }
                });
                latch.countDown();
                try {
                    latch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Thread 2: start");
                int i = 0;
                while (i < 100) {
                    boolean value = i % 2 == 0;
                    System.out.println("Thread 2: setting flag to " + value);
                    Flag.this.setFlag(value);
                    ++i;
                }
                end.countDown();
            }
        });
        one.start();
        two.start();
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        flag.freeze();
        System.out.println("flag freezed...");
        flag.setFlag(flag.getFlag() == false);
        System.out.println("flag defreezed...");
        flag.defreeze();
        try {
            end.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static abstract class DoInSync<T> {
        Flag<T> flag;

        void setFlagInstance(Flag<T> flag) {
            this.flag = flag;
        }

        protected boolean isImmutable() {
            return this.flag instanceof ImmutableFlag;
        }

        protected void setFlag(T value) {
            if (this.flag instanceof ImmutableFlag) {
                throw new UnsupportedOperationException("trying to set flag of the immutable flag!");
            }
            this.flag.value = value;
            this.flag.notifier.setValue(value);
            this.flag.listeners.notify(this.flag.notifier);
        }

        protected T getFlag() {
            return this.flag.getFlag();
        }

        public abstract void execute(T var1);
    }

    class SetInSync
    extends DoInSync<T> {
        T newValue;

        public SetInSync(T newValue) {
            this.newValue = newValue;
        }

        @Override
        public void execute(T flagValue) {
            if (this.newValue == null && flagValue != null || !this.newValue.equals(flagValue)) {
                this.setFlag(this.newValue);
            }
        }
    }
}

