/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils;

import java.io.OutputStream;
import java.io.Serializable;

public class StringOutputStream
extends OutputStream
implements Serializable {
    private StringBuffer buffer = new StringBuffer();
    private String resultString = null;

    public String getString() {
        if (this.resultString != null) {
            return this.resultString;
        }
        return this.buffer.toString();
    }

    @Override
    public void close() {
        this.resultString = this.buffer.toString();
        this.buffer = null;
    }

    @Override
    public void write(byte[] b) {
        this.buffer.append(this.toCharArray(b));
    }

    private char[] toCharArray(byte[] barr) {
        if (barr == null) {
            return null;
        }
        char[] carr = new char[barr.length];
        int i = 0;
        while (i < barr.length) {
            carr[i] = (char)barr[i];
            ++i;
        }
        return carr;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || len < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException("StringOutputStream.write: Parameters out of bounds.");
        }
        byte[] bytes = new byte[len];
        int i = 0;
        while (i < len) {
            bytes[i] = b[off];
            ++off;
            ++i;
        }
        this.buffer.append(this.toCharArray(bytes));
    }

    @Override
    public void write(int b) {
        this.buffer.append((char)b);
    }
}

