/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.utils;

import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.ImmutableFlag;
import cz.cuni.amis.utils.flag.WaitForFlagChange;
import java.util.concurrent.TimeUnit;

public abstract class Job<RESULT> {
    private RESULT jobResult = null;
    private Exception thrownException = null;
    private Thread thread = null;
    private Object mutex = new Object();
    private Flag<Boolean> running = new Flag<Boolean>(false);

    protected Object getMutex() {
        return this.mutex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interrupt() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.thread != null && this.thread.isAlive()) {
                this.thread.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInterrupted() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.thread != null) {
                return this.thread.isInterrupted();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableFlag<Boolean> getRunningFlag() {
        Object object = this.mutex;
        synchronized (object) {
            return this.running.getImmutable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Object object = this.mutex;
        synchronized (object) {
            return this.running.getFlag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinished() {
        Object object = this.mutex;
        synchronized (object) {
            return this.isStarted() && !this.isRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFinishedOk() {
        Object object = this.mutex;
        synchronized (object) {
            return this.isFinished() && !this.isException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        Object object = this.mutex;
        synchronized (object) {
            return this.thread != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setResult(RESULT result) {
        Object object = this.mutex;
        synchronized (object) {
            this.jobResult = result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RESULT getResult() {
        Object object = this.mutex;
        synchronized (object) {
            return this.jobResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isException() {
        Object object = this.mutex;
        synchronized (object) {
            return this.thrownException != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception getException() {
        Object object = this.mutex;
        synchronized (object) {
            return this.thrownException;
        }
    }

    protected abstract void job() throws Exception;

    public void await() throws InterruptedException {
        new WaitForFlagChange<Boolean>(this.running, false).await();
    }

    public boolean await(long timeoutMillis) throws InterruptedException {
        return new WaitForFlagChange<Boolean>(this.running, false).await(timeoutMillis, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job<RESULT> startJob() {
        Object object = this.mutex;
        synchronized (object) {
            return this.startJob("JobRunnable[" + this + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Job<RESULT> startJob(String threadName) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.thread != null) {
                throw new JobWasAlreadyStartedException("Job was already started... can't run one job twice.");
            }
            this.thread = new Thread((Runnable)new RunJob(), threadName);
            this.running.setFlag(true);
            this.thread.start();
            return this;
        }
    }

    public static class JobWasAlreadyStartedException
    extends RuntimeException {
        public JobWasAlreadyStartedException(String text) {
            super(text);
        }
    }

    private class RunJob
    implements Runnable {
        private RunJob() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block17: {
                try {
                    try {
                        Job.this.job();
                    }
                    catch (Exception e) {
                        Object object = Job.this.mutex;
                        synchronized (object) {
                            Job.this.thrownException = e;
                        }
                        Object object2 = Job.this.mutex;
                        synchronized (object2) {
                            Job.this.running.setFlag(false);
                            break block17;
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object object = Job.this.mutex;
                    synchronized (object) {
                        Job.this.running.setFlag(false);
                    }
                    throw throwable;
                }
                Object object = Job.this.mutex;
                synchronized (object) {
                    Job.this.running.setFlag(false);
                }
            }
        }
    }
}

