/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.utils;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateGoingDown;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateFailed;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.PogamutProperty;
import cz.cuni.amis.pogamut.ut2004.bot.IUT2004BotController;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004BotModule;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.concurrent.CountDownLatch;

public class MultipleUT2004BotRunner<T extends UT2004Bot> {
    protected String host;
    protected int port;
    protected int number;
    protected UT2004BotFactory factory;
    protected String name;
    private Object agentCounterMutex = new Object();
    private int agentCounter;
    private boolean agentsKilled = false;
    private UT2004Bot[] agents;
    private CountDownLatch latch;

    public MultipleUT2004BotRunner(int number, Class<? extends IUT2004BotController> controllerClass, String name, String host, int port) {
        this.factory = new UT2004BotFactory(new UT2004BotModule(controllerClass));
        this.name = name;
        this.port = port;
        this.host = host;
        this.number = number;
        if (number < 0) {
            throw new IllegalArgumentException("Can't have < 0 bot instances.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgentId getAgentId() {
        Object object = this.agentCounterMutex;
        synchronized (object) {
            return new AgentId(String.valueOf(this.name) + ++this.agentCounter);
        }
    }

    public MultipleUT2004BotRunner(int number, Class<? extends IUT2004BotController> controllerClass, String name) {
        this(number, controllerClass, name, Pogamut.getPlatform().getProperty(PogamutProperty.POGAMUT_UT2004_BOT_HOST.getKey()), Pogamut.getPlatform().getIntProperty(PogamutProperty.POGAMUT_UT2004_BOT_PORT.getKey()));
    }

    public SocketConnectionAddress getAddress() {
        return new SocketConnectionAddress(this.host, this.port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void killAgents() {
        if (this.agentsKilled) {
            return;
        }
        UT2004Bot[] uT2004BotArray = this.agents;
        synchronized (this.agents) {
            if (!this.agentsKilled) {
                this.agentsKilled = true;
                int i = 0;
                while (i < this.number) {
                    if (this.agents[i] != null) {
                        if (this.agents[i].notInState(IAgentStateDown.class, IAgentStateGoingDown.class)) {
                            this.agents[i].kill();
                        }
                    }
                    ++i;
                }
                while (this.latch.getCount() > 0L) {
                    this.latch.countDown();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public synchronized void startAgent() throws PogamutException {
        if (this.number == 0) {
            return;
        }
        this.preAllInitHook();
        this.agents = new UT2004Bot[this.number];
        int i = 0;
        while (i < this.number) {
            this.agents[i] = null;
            ++i;
        }
        this.agentsKilled = false;
        FlagListener[] agentStateListener = new FlagListener[this.number];
        this.latch = new CountDownLatch(this.number);
        try {
            try {
                int i2 = 0;
                while (i2 < this.number) {
                    UT2004Bot agent;
                    UT2004Bot[] uT2004BotArray = this.agents;
                    // MONITORENTER : this.agents
                    if (this.agentsKilled) {
                        // MONITOREXIT : uT2004BotArray
                        break;
                    }
                    this.preInitHook();
                    this.agents[i2] = agent = (UT2004Bot)this.factory.newAgent((IAgentId)this.getAgentId(), this.getAddress());
                    agent.getLogger().addDefaultConsoleHandler();
                    FlagListener<IAgentState> listener = new FlagListener<IAgentState>(){

                        @Override
                        public void flagChanged(IAgentState changedValue) {
                            if (changedValue instanceof IAgentStateFailed) {
                                MultipleUT2004BotRunner.this.killAgents();
                            } else if (changedValue instanceof IAgentStateDown) {
                                MultipleUT2004BotRunner.this.latch.countDown();
                            }
                        }
                    };
                    agent.getState().addListener(listener);
                    agentStateListener[i2] = listener;
                    this.preStartHook(agent);
                    agent.start();
                    this.postStartHook(agent);
                    // MONITOREXIT : uT2004BotArray
                    ++i2;
                }
                this.postAllStartHook(this.agents);
                try {
                    this.latch.await();
                }
                catch (InterruptedException e) {
                    throw new PogamutInterruptedException("Interrupted while waiting for all agents to finishes.", e, (Object)this);
                }
            }
            catch (Exception e) {
                this.killAgents();
                if (!(e instanceof PogamutException)) throw new PogamutException(e, (Object)this);
                throw (PogamutException)e;
            }
        }
        catch (Throwable throwable) {
            try {
                int i3 = 0;
                while (true) {
                    if (i3 >= this.agents.length) {
                        throw throwable;
                    }
                    this.agents[i3] = null;
                    ++i3;
                }
            }
            finally {
                Pogamut.getPlatform().close();
            }
        }
        try {
            int i4 = 0;
            while (i4 < this.agents.length) {
                this.agents[i4] = null;
                ++i4;
            }
            return;
        }
        finally {
            Pogamut.getPlatform().close();
        }
    }

    protected void preAllInitHook() {
    }

    protected void postAllStartHook(UT2004Bot[] startedAgents) {
    }

    protected void preInitHook() throws PogamutException {
    }

    protected void preStartHook(T agent) throws PogamutException {
    }

    protected void postStartHook(T agent) throws PogamutException {
    }
}

