/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.storyworld.place;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import cz.cuni.amis.pogamut.ut2004.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.translator.shared.events.MapPointListObtained;
import cz.cuni.amis.pogamut.ut2004.storyworld.place.SPStoryPlace;
import cz.cuni.amis.utils.collections.MyCollections;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@XStreamAlias(value="base")
public class SPStoryPlaceBase
extends SPStoryPlace {
    @XStreamOmitField
    private static Set immutableEmptySet = Collections.unmodifiableSet(new HashSet());
    @XStreamOmitField
    private Set<NavPoint> navPoints = new HashSet<NavPoint>();
    @XStreamImplicit(itemFieldName="nav")
    private List<String> navPointIds = new ArrayList<String>();

    public SPStoryPlaceBase(String name, SPStoryPlace inside, String[] navPoints) {
        super(name, inside);
        this.navPointIds.addAll(MyCollections.asList(navPoints));
    }

    private SPStoryPlaceBase readResolve() {
        this.navPoints = new HashSet<NavPoint>();
        return this;
    }

    @Override
    public Set<NavPoint> getNavPoints() {
        return this.navPoints;
    }

    protected void setVirtualPlaces(NavPoint[] places) {
        this.navPoints.clear();
        this.navPoints.addAll(MyCollections.asList(places));
    }

    protected void setVirtualPlaces(String[] names) {
        this.navPointIds.clear();
        this.navPointIds.addAll(MyCollections.asList(names));
    }

    protected void bountNavPoints(MapPointListObtained map) {
        NavPoint[] navPoints = new NavPoint[this.navPointIds.size()];
        int i = 0;
        for (String id : this.navPointIds) {
            NavPoint navPoint = map.getNavPoints().get(UnrealId.get(id));
            if (navPoint == null) {
                throw new RuntimeException("nav point " + id + " can't be found in the map");
            }
            navPoints[i++] = navPoint;
        }
        this.setVirtualPlaces(navPoints);
    }

    @Override
    public Set<SPStoryPlace> getContainsPlaces() {
        return immutableEmptySet;
    }

    @Override
    public Set<SPStoryPlace> getContainsAllPlaces() {
        return immutableEmptySet;
    }
}

