/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.server;

import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.agent.impl.AbstractAgent;
import cz.cuni.amis.pogamut.base.agent.impl.AgentId;
import cz.cuni.amis.pogamut.base.agent.state.WaitForAgentStateChange;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateGoingUp;
import cz.cuni.amis.pogamut.base.agent.state.level2.IAgentStateRunning;
import cz.cuni.amis.pogamut.base.agent.utils.AgentKeepAlive;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.utils.Pogamut;
import cz.cuni.amis.pogamut.base.utils.PogamutProperty;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerFactory;
import cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent.UT2004ServerModule;
import cz.cuni.amis.pogamut.ut2004.server.IUT2004Server;
import cz.cuni.amis.pogamut.ut2004.server.exception.UCCStartException;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapper;
import cz.cuni.amis.utils.flag.Flag;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import junit.framework.Assert;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class Test05_UT2004Server_AutoReconnect {
    private static boolean useInternalUcc = !Pogamut.getPlatform().getProperty(PogamutProperty.POGAMUT_UNREAL_TEST_EXT_SERVER.getKey()).equals("true");
    private UCCWrapper uccWrapper;
    IUT2004Server server = null;
    UT2004ServerFactory factory;

    @Before
    public void startUp() throws UCCStartException {
        if (!useInternalUcc) {
            Assert.fail((String)"Must use internal ucc to be able to start/stop gb2004 server and test AgentKeepAlive.");
        }
        System.out.println("Starting ucc...");
        this.uccWrapper = new UCCWrapper(new UCCWrapper.UCCWrapperConf());
    }

    @After
    public void tearDown() {
        if (this.server != null) {
            this.server.stop();
        }
        System.out.println("Stopping ucc...");
        this.uccWrapper.stop();
        System.out.println("Closing PogamutPlatform...");
        Pogamut.getPlatform().close();
    }

    private boolean awaitAgentUp(AbstractAgent agent) {
        System.out.println("Awaiting server up (timeout 60s)...");
        IAgentState state = (IAgentState)new WaitForAgentStateChange((Flag<IAgentState>)agent.getState(), (Class<? extends IAgentState>)IAgentStateRunning.class).await(60000L, TimeUnit.MILLISECONDS);
        return state != null && state instanceof IAgentStateRunning;
    }

    @Test
    public void test01_KeepAlive() {
        String host = this.uccWrapper.getHost();
        int port = this.uccWrapper.getControlPort();
        this.factory = new UT2004ServerFactory(new UT2004ServerModule());
        AgentId agentId = new AgentId("Test server-keepalive");
        this.server = (IUT2004Server)this.factory.newAgent((IAgentId)agentId, new SocketConnectionAddress(host, port));
        AbstractAgent serverAgent = (AbstractAgent)((Object)this.server);
        serverAgent.getLogger().setLevel(Level.WARNING);
        serverAgent.getLogger().addDefaultConsoleHandler();
        AgentKeepAlive keepAlive = new AgentKeepAlive(this.server, 1000L);
        keepAlive.start();
        int i = 0;
        while (i < 20) {
            System.out.println("Reconnection " + (i + 1) + " / 20 ...");
            if (!this.awaitAgentUp(serverAgent)) {
                Assert.fail((String)"Failed to reconnect to server.");
            } else {
                System.out.println("Connected...");
            }
            try {
                System.out.println("Sleeping for 1000ms.");
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.out.println("Checking server state...");
            if (!serverAgent.inState(IAgentStateRunning.class)) {
                Assert.fail((String)"Agent is not running!");
            }
            System.out.println("Server is running - OK.");
            System.out.println("Stopping UCC...");
            this.uccWrapper.stop();
            if (serverAgent.awaitState(IAgentStateDown.class, 10000L) == null) {
                Assert.fail((String)"Failed to stop the server...");
            }
            try {
                System.out.println("Sleeping for 1000ms.");
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!serverAgent.inState(IAgentStateDown.class, IAgentStateGoingUp.class)) {
                Assert.fail((String)"Agent is still running!");
            }
            System.out.println("Server is not running - OK.");
            System.out.println("Starting UCC...");
            this.uccWrapper = new UCCWrapper(new UCCWrapper.UCCWrapperConf());
            this.server.setAddress(this.uccWrapper.getHost(), this.uccWrapper.getControlPort());
            ++i;
        }
        keepAlive.stop();
        this.server.stop();
        System.out.println("---/// TEST OK ///---");
    }

    public static void main(String[] args) {
        Test05_UT2004Server_AutoReconnect test = new Test05_UT2004Server_AutoReconnect();
        test.startUp();
        test.test01_KeepAlive();
        test.tearDown();
    }
}

