/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.factory.guice.remoteagent;

import com.google.inject.AbstractModule;
import com.google.inject.name.Names;
import cz.cuni.amis.pogamut.base.agent.IAgentId;
import cz.cuni.amis.pogamut.base.communication.connection.IWorldConnection;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.ISocketConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnection;
import cz.cuni.amis.pogamut.base.communication.connection.impl.socket.SocketConnectionAddress;
import cz.cuni.amis.pogamut.base.communication.parser.IWorldMessageParser;
import cz.cuni.amis.pogamut.base.communication.parser.impl.yylex.IYylex;
import cz.cuni.amis.pogamut.base.communication.parser.impl.yylex.IYylexObserver;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencies;
import cz.cuni.amis.pogamut.base.component.controller.ComponentDependencyType;
import cz.cuni.amis.pogamut.base.factory.guice.remoteagent.GuiceRemoteAgentModule;
import cz.cuni.amis.pogamut.base.utils.guice.AdaptableProvider;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Yylex;
import cz.cuni.amis.pogamut.ut2004.communication.parser.IUT2004Yylex;
import cz.cuni.amis.pogamut.ut2004.communication.parser.UT2004Parser;
import cz.cuni.amis.utils.NullCheck;
import java.lang.annotation.Annotation;

public class UT2004CommunicationModule
extends GuiceRemoteAgentModule<SocketConnectionAddress> {
    protected AdaptableProvider<ComponentDependencies> connectionDependenciesProvider = new AdaptableProvider<Object>(null);

    protected UT2004CommunicationModule() {
    }

    public void newBindings(IAgentId agentId, SocketConnectionAddress address) {
        NullCheck.check(agentId, "agentId");
        NullCheck.check(address, "address");
        this.getAgentScope().clearScope();
        this.getAgentNameProvider().set(agentId);
        this.getAddressProvider().set(address);
        this.connectionDependenciesProvider.set(new ComponentDependencies(ComponentDependencyType.STARTS_WITH).add(agentId));
    }

    @Override
    protected void configureModules() {
        super.configureModules();
        this.addModule(new AbstractModule(){

            public void configure() {
                this.bind(IWorldConnection.class).to(SocketConnection.class);
                this.bind(ComponentDependencies.class).annotatedWith((Annotation)Names.named((String)"ConnectionDependency")).toProvider(UT2004CommunicationModule.this.connectionDependenciesProvider);
                this.bind(ISocketConnectionAddress.class).annotatedWith((Annotation)Names.named((String)"ConnectionAddressDependency")).toProvider(UT2004CommunicationModule.this.getAddressProvider());
                this.bind(IWorldMessageParser.class).to(UT2004Parser.class);
                this.bind(IYylex.class).to(IUT2004Yylex.class);
                this.bind(IUT2004Yylex.class).to(Yylex.class);
                this.bind(IYylexObserver.class).to(IYylexObserver.LogObserver.class);
            }
        });
    }
}

