/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples;

import cz.cuni.amis.introspection.java.JProp;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectClassEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.base.utils.math.DistanceUtils;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.base3d.worldview.object.event.WorldObjectAppearedEvent;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Bumped;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.utils.SingleUT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;

@AgentScoped
public class ResponsiveBot
extends UT2004BotModuleController {
    @JProp
    int lastHealth = 100;
    private boolean wasCloseBefore = false;

    @EventListener(eventClass=Bumped.class)
    private void bumped(Bumped event) {
        Location v = event.getLocation().sub(this.bot.getLocation()).scale(5.0);
        Location target = this.bot.getLocation().sub(v);
        this.move.strafeTo((ILocated)target, event.getLocation());
    }

    @ObjectClassEventListener(eventClass=WorldObjectAppearedEvent.class, objectClass=Player.class)
    private void playerAppeared(WorldObjectAppearedEvent<Player> event) {
        this.body.getCommunication().sendGlobalTextMessage("Hello " + ((Player)event.getObject()).getName() + "!");
    }

    @ObjectClassEventListener(eventClass=WorldObjectUpdatedEvent.class, objectClass=Player.class)
    private void playerUpdated(WorldObjectUpdatedEvent<Player> event) {
        Player player = (Player)event.getObject();
        if (player.getLocation().getDistance(this.bot.getLocation()) < 250.0) {
            if (!this.wasCloseBefore) {
                this.body.getCommunication().sendGlobalTextMessage("What do you want " + player.getName() + "?");
                this.wasCloseBefore = true;
            }
        } else {
            this.wasCloseBefore = false;
        }
    }

    @Override
    public void prepareBot(UT2004Bot bot) {
    }

    @Override
    public Initialize getInitializeCommand() {
        return new Initialize();
    }

    @Override
    public void botSpawned(GameInfo gameInfo, ConfigChange config, InitedMessage init, Self self) {
        this.body.getCommunication().sendGlobalTextMessage("I am alive!");
    }

    @Override
    public void logic() throws PogamutException {
        Self self = this.getWorldView().getSingle(Self.class);
        int health = self.getHealth();
        if (health < this.lastHealth) {
            this.lastHealth = health;
            NavPoint secondNav = DistanceUtils.getSecondNearestVisible(this.getWorldView().getAll(NavPoint.class).values(), self.getLocation());
            if (secondNav == null) {
                this.move.turnVertical(32000);
            } else {
                this.move.moveTo(secondNav);
            }
        }
    }

    @Override
    public void botKilled(BotKilled event) {
        this.lastHealth = 100;
    }

    public static void main(String[] args) throws PogamutException {
        new SingleUT2004BotRunner(ResponsiveBot.class, "ResponsiveBot").startAgent();
    }
}

