/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.examples;

import cz.cuni.amis.introspection.java.JProp;
import cz.cuni.amis.pogamut.base.utils.guice.AgentScoped;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004BotModuleController;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.Initialize;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.RemoveRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.AutoTraceRay;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.ConfigChange;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.InitedMessage;
import cz.cuni.amis.pogamut.ut2004.utils.SingleUT2004BotRunner;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.FlagListener;
import javax.vecmath.Vector3d;

@AgentScoped
public class RaycastingBot
extends UT2004BotModuleController {
    protected static final String FRONT = "frontRay";
    protected static final String LEFT45 = "left45Ray";
    protected static final String LEFT90 = "left90Ray";
    protected static final String RIGHT45 = "right45Ray";
    protected static final String RIGHT90 = "right90Ray";
    AutoTraceRay left;
    AutoTraceRay front;
    AutoTraceRay right;
    boolean first = true;
    boolean raysInitialized = false;
    @JProp
    boolean sensorLeft = false;
    @JProp
    boolean sensorRight = false;
    @JProp
    boolean sensorFront = false;
    @JProp
    boolean moving = false;
    @JProp
    boolean sensor = false;
    @JProp
    int turnSleep = 250;
    float moveSpeed = 0.6f;
    @JProp
    int smallTurn = 30;
    @JProp
    int bigTurn = 90;

    @Override
    public Initialize getInitializeCommand() {
        return new Initialize();
    }

    @Override
    public void botInitialized(GameInfo info, ConfigChange currentConfig, InitedMessage init) {
        int rayLength = 250;
        boolean fastTrace = true;
        boolean floorCorrection = false;
        boolean traceActor = false;
        this.getAct().act(new RemoveRay("All"));
        this.raycasting.createRay(LEFT90, new Vector3d(0.0, -1.0, 0.0), 250, fastTrace, floorCorrection, traceActor);
        this.raycasting.createRay(LEFT45, new Vector3d(1.0, -1.0, 0.0), 250, fastTrace, floorCorrection, traceActor);
        this.raycasting.createRay(FRONT, new Vector3d(1.0, 0.0, 0.0), 250, fastTrace, floorCorrection, traceActor);
        this.raycasting.createRay(RIGHT45, new Vector3d(1.0, 1.0, 0.0), 250, fastTrace, floorCorrection, traceActor);
        this.raycasting.createRay(RIGHT90, new Vector3d(0.0, 1.0, 0.0), 250, fastTrace, floorCorrection, traceActor);
        this.raycasting.getAllRaysInitialized().addListener(new FlagListener<Boolean>(){

            @Override
            public void flagChanged(Boolean changedValue) {
                RaycastingBot.this.left = RaycastingBot.this.raycasting.getRay(RaycastingBot.LEFT45);
                RaycastingBot.this.front = RaycastingBot.this.raycasting.getRay(RaycastingBot.FRONT);
                RaycastingBot.this.right = RaycastingBot.this.raycasting.getRay(RaycastingBot.RIGHT45);
            }
        });
        this.raycasting.endRayInitSequence();
        this.config.setSpeedMultiplier(this.moveSpeed);
        this.config.setDrawTraceLines(true);
        this.config.setAutoTrace(true);
    }

    @Override
    public void logic() throws PogamutException {
        if (this.raycasting.getAllRaysInitialized().getFlag().booleanValue()) {
            this.sensorFront = this.front.isResult();
            this.sensorLeft = this.left.isResult();
            this.sensorRight = this.right.isResult();
            boolean bl = this.sensor = this.sensorFront || this.sensorLeft || this.sensorRight;
            if (this.sensor) {
                if (this.moving) {
                    this.move.stopMovement();
                    this.moving = false;
                }
                if (this.sensorFront) {
                    if (this.sensorLeft) {
                        if (this.sensorRight) {
                            this.move.turnHorizontal(this.bigTurn);
                        } else {
                            this.move.turnHorizontal(this.smallTurn);
                        }
                    } else if (this.sensorRight) {
                        this.move.turnHorizontal(-this.smallTurn);
                    } else {
                        this.move.turnHorizontal(this.smallTurn);
                    }
                } else if (this.sensorLeft) {
                    if (this.sensorRight) {
                        this.goForward();
                    } else {
                        this.move.turnHorizontal(this.smallTurn);
                    }
                } else if (this.sensorRight) {
                    this.move.turnHorizontal(-this.smallTurn);
                } else {
                    this.goForward();
                }
            } else {
                this.goForward();
            }
        }
    }

    private void goForward() {
        this.move.moveContinuos();
        this.moving = true;
    }

    public static void main(String[] args) throws PogamutException {
        new SingleUT2004BotRunner(RaycastingBot.class, "RaycastingBot").startAgent();
    }
}

