/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.ListenerLevel;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObject;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.WorldViewTestContext;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.AbstractObjectEventWrapper;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.EventWrapperWithCallCount;
import org.junit.Assert;

@XStreamAlias(value="ObjectClassEventWrapper")
public class ObjectClassEventWrapper<OBJECT extends IWorldObject>
extends AbstractObjectEventWrapper<OBJECT> {
    @XStreamAlias(value="Class")
    private final Class<OBJECT> objectClass;
    @XStreamOmitField
    private ObjectClassListenerWrapper<?> listenerWrapper;

    public ObjectClassEventWrapper(WorldViewTestContext ctx, IWorldObjectEvent<OBJECT> expectedEvent, Class<OBJECT> objectClass, ListenerLevel level) {
        super(ctx, expectedEvent, level);
        Assert.assertTrue((String)"Use ObjectEventWrapper, if you wish to register a class D or E listener.", (level == ListenerLevel.B || level == ListenerLevel.C ? 1 : 0) != 0);
        this.objectClass = objectClass;
    }

    @Override
    protected void setListenerWrapper() {
        this.listenerWrapper = new ObjectClassListenerWrapper();
    }

    @Override
    public void registerToWorldView(IWorldView worldView) {
        if (!this.ctx.getWorldView().isListening((Class<?>)this.objectClass, (IWorldObjectEventListener<?, ?>)this.listenerWrapper) && !this.ctx.getWorldView().isListening(this.objectClass, this.getExpectedEvent().getClass(), this.listenerWrapper)) {
            this.ctx.getLog().info("Registering listener of: " + this.getExpectedEventString());
            switch (this.getListenerLevel()) {
                case B: {
                    worldView.addObjectListener(this.objectClass, this.listenerWrapper);
                    break;
                }
                case C: {
                    worldView.addObjectListener(this.objectClass, this.getExpectedEvent().getClass(), this.listenerWrapper);
                }
            }
        }
    }

    public Class<OBJECT> getObjectClass() {
        return this.objectClass;
    }

    protected class ObjectClassListenerWrapper<EVENT extends IWorldObjectEvent<OBJECT>>
    implements IWorldObjectEventListener<OBJECT, EVENT> {
        protected ObjectClassListenerWrapper() {
        }

        @Override
        public void notify(EVENT event) {
            EventWrapperWithCallCount mock_wrapper_with_counts = ObjectClassEventWrapper.this.ctx.getCurrentMockWrapper();
            ObjectClassEventWrapper.this.ctx.getLog().info("ObjectClassListenerNotify: " + event.toString() + " call#: " + (mock_wrapper_with_counts.getCalled() + 1));
            Assert.assertTrue((String)("Unexpected event has been raised (possibly out of order).\n" + event.toString() + "\nExpected for this listener: " + ObjectClassEventWrapper.this.getExpectedEventString() + "\nExpected for strict execution: " + mock_wrapper_with_counts.getEventWrapper().getExpectedEventString()), (!ObjectClassEventWrapper.this.ctx.isStrictExecution() || event.getClass() == mock_wrapper_with_counts.getEventWrapper().getExpectedEvent().getClass() && ObjectClassEventWrapper.this.getObjectClass() == event.getObject().getClass() ? 1 : 0) != 0);
            ObjectClassEventWrapper.this.notify((IWorldEvent)event);
        }
    }
}

