/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.WorldViewTestContext;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.testplan.wrapper.EventWrapper;
import org.junit.Assert;

@XStreamAlias(value="EventWrapperAndCount")
public class EventWrapperWithCallCount {
    @XStreamOmitField
    private int called = 0;
    @XStreamAlias(value="Wrapper")
    private EventWrapper wrapper;
    @XStreamAsAttribute
    @XStreamAlias(value="count")
    private final int expectedNumberOfCalls;
    private WorldViewTestContext ctx;

    public EventWrapperWithCallCount(WorldViewTestContext ctx, EventWrapper wrapper) {
        this(ctx, wrapper, 1);
    }

    public EventWrapperWithCallCount(WorldViewTestContext ctx, EventWrapper wrapper, int expectedNumberOfCalls) {
        this.ctx = ctx;
        this.expectedNumberOfCalls = expectedNumberOfCalls;
        this.wrapper = wrapper;
    }

    public int wasCalled() {
        return this.called;
    }

    public boolean hasBeenCalledExpectedNumberOfTimes() {
        return this.called == this.expectedNumberOfCalls;
    }

    public int getCalled() {
        return this.called;
    }

    public EventWrapper getEventWrapper() {
        return this.wrapper;
    }

    public void incCalled() {
        ++this.called;
        Assert.assertTrue((String)("Event has been raised times more than expected. " + this.wrapper.getExpectedEvent().toString()), (this.called <= this.expectedNumberOfCalls ? 1 : 0) != 0);
        if (this.ctx.isStrictExecution() && this.hasBeenCalledExpectedNumberOfTimes()) {
            this.ctx.incCurrentEventForStrictExecution();
        }
        if (this.ctx.getCurrentEventForStrictExecution() < this.ctx.getExpectedEventsPlan().size()) {
            this.ctx.getLog().info("Next expected event: " + this.ctx.getCurrentMockWrapper().getEventWrapper().getExpectedEvent().toString());
        }
    }

    public int getExpectedNumberOfCalls() {
        return this.expectedNumberOfCalls;
    }
}

