/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.worldview.map;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.map.Box;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.map.MapInfo;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.map.Waylink;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.map.Waypoint;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UT2004Map
implements Serializable {
    private String name = "";
    private MapInfo info;
    private Map<String, Waypoint> waypoints = new HashMap<String, Waypoint>();

    public UT2004Map(IWorldView worldView) {
        Collection<NavPoint> navs = worldView.getAll(NavPoint.class).values();
        for (NavPoint nav : navs) {
            this.waypoints.put(nav.getId().getStringId(), new Waypoint(nav));
        }
        for (Waypoint point : this.waypoints.values()) {
            for (Waylink link : point.getOutgoingEdges()) {
                Waypoint end = this.waypoints.get(link.getEndId());
                link.setEnd(end);
            }
        }
    }

    public void addInfo(MapInfo info) {
        this.info = info;
    }

    public MapInfo getInfo() {
        return this.info;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Collection<Waypoint> vertexSet() {
        return Collections.unmodifiableCollection(this.waypoints.values());
    }

    public Set<Waylink> edgeSet() {
        HashSet<Waylink> edges = new HashSet<Waylink>();
        for (Waypoint nav : this.waypoints.values()) {
            edges.addAll(nav.getOutgoingEdges());
        }
        return edges;
    }

    public void printInfo() {
        System.out.println("Printing info about map, vers: " + this.waypoints.size() + ", links: " + this.edgeSet().size());
        for (Map.Entry<String, Waypoint> entry : this.waypoints.entrySet()) {
            System.out.println(" * " + entry.getKey() + " " + entry.getValue().getLocation());
        }
    }

    public Box getBox() {
        double minX = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double minY = Double.MAX_VALUE;
        double maxY = Double.MIN_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxZ = Double.MIN_VALUE;
        Collection<Waypoint> navs = this.vertexSet();
        for (Waypoint nav : navs) {
            Location loc = nav.getLocation();
            if (loc.x < minX) {
                minX = loc.x;
            }
            if (loc.x > maxX) {
                maxX = loc.x;
            }
            if (loc.y < minY) {
                minY = loc.y;
            }
            if (loc.y > maxY) {
                maxY = loc.y;
            }
            if (loc.z < minZ) {
                minZ = loc.z;
            }
            if (!(loc.z > maxZ)) continue;
            maxZ = loc.z;
        }
        return new Box(minX, minY, minZ, maxX, maxY, maxZ);
    }
}

