/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.communication.worldview;

import cz.cuni.amis.pogamut.base.communication.translator.event.IWorldChangeEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.ILockableWorldView;
import cz.cuni.amis.pogamut.base.component.bus.exception.ComponentNotRunningException;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.AbstractBatchAwareWorldViewTest;
import cz.cuni.amis.utils.exception.PogamutInterruptedException;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.flag.FlagListener;
import java.io.File;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class AbstractSyncWorldViewTest
extends AbstractBatchAwareWorldViewTest {
    private Thread asyncTestThread = null;
    private IWorldChangeEvent lastEvent = null;
    private CyclicBarrier barrier = new CyclicBarrier(2);
    private Flag<Boolean> consistentCriticalSection = new Flag<Boolean>(false);
    private FlagListener<Boolean> runningListener = new FlagListener<Boolean>(){

        @Override
        public void flagChanged(Boolean changedValue) {
        }
    };

    protected AbstractSyncWorldViewTest(File planFile) {
        super(planFile);
    }

    @Override
    protected void preNotifications() {
        this.asyncTestThread = new Thread(new Runnable(){

            @Override
            public void run() {
                AbstractSyncWorldViewTest.this.asyncDoTest();
            }
        });
        this.asyncTestThread.start();
    }

    @Override
    protected void postTest() {
        try {
            this.barrier.await(999999999L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.fail("Test thread interrupted at post-test barrier: " + e.toString());
        }
        catch (BrokenBarrierException e) {
            e.printStackTrace();
            this.fail("Barrier broken in test thread at post-test barrier: " + e.toString());
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            this.fail("Failed to meetup with asyncDoTest thread at the end of test run.");
        }
        this.getContext().getLog().info("leaving postTest");
    }

    protected void asyncDoTest() {
        while (this.getContext().getRunningFlag().getFlag().booleanValue()) {
            try {
                this.getContext().getLog().info("locking worldview");
                ((ILockableWorldView)this.getContext().getWorldView()).lock();
                this.getContext().getLog().info("locked");
                this.getInnerRunning().setFlag(true);
                try {
                    try {
                        long currTime = System.currentTimeMillis();
                        int sleepTime = 100;
                        this.getContext().getLog().info("sleeping for " + sleepTime + " ms");
                        this.getInnerRunning().waitFor(sleepTime, (T[])new Boolean[]{false});
                        this.getInnerRunning().setFlag(false);
                    }
                    catch (PogamutInterruptedException e) {
                        e.printStackTrace();
                        this.getContext().getLog().info("Interrupted in asyncDoTest.");
                        this.fail("Interrupted in asyncDoTest while blocking notifications in worldview.");
                        this.getContext().getLog().info("unlocking worldview");
                        ((ILockableWorldView)this.getContext().getWorldView()).unlock();
                        this.getContext().getLog().info("unlocked");
                        break;
                    }
                }
                catch (Throwable throwable) {
                    this.getContext().getLog().info("unlocking worldview");
                    ((ILockableWorldView)this.getContext().getWorldView()).unlock();
                    this.getContext().getLog().info("unlocked");
                    throw throwable;
                }
                this.getContext().getLog().info("unlocking worldview");
                ((ILockableWorldView)this.getContext().getWorldView()).unlock();
                this.getContext().getLog().info("unlocked");
            }
            catch (ComponentNotRunningException e) {
                this.getContext().getLog().info("WorldView has been stopped.");
                break;
            }
        }
        try {
            this.barrier.await(10000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.fail("Method asyncDoTest interrupted at post-test barrier: " + e.getMessage());
        }
        catch (BrokenBarrierException e) {
            e.printStackTrace();
            this.fail("Barrier broken in method asyncDoTest at post-test barrier: " + e.getMessage());
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            this.fail("Failed to meetup with main thread at the end of test run.");
        }
    }

    private Flag<Boolean> getInnerRunning() {
        return this.consistentCriticalSection;
    }
}

